package com.se.solarenginedemo;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

//import com.reyun.remote.config.OnRemoteConfigReceivedGenericsData;
//import com.reyun.remote.config.RemoteConfigManager;
//import com.se.core.SolarEngineManager;
//import com.se.core.infos.SECustomEventModel;

import com.reyun.remote.config.OnRemoteConfigReceivedData;
import com.reyun.remote.config.OnRemoteConfigReceivedGenericsData;
import com.reyun.remote.config.RemoteConfigManager;
import com.reyun.solar.engine.SolarEngineManager;
import com.reyun.solar.engine.infos.SECustomEventModel;

import org.json.JSONException;
import org.json.JSONObject;

public class MainActivity extends AppCompatActivity {

    private Button btnTrackEvent;
    private Button btnReportEvent;
    private Button btnUserInit;
    private Button btnAsyncFetchRemoteConfig;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // 初始化按钮
        initViews();
        // 设置按钮点击事件
        setupClickListeners();

        Intent intent = getIntent();
        Uri data = intent.getData();
        if (data != null) {
            Log.d("Demo", "onCreate Deeplink appDeeplinkOpenURI :" + data.toString());
            SolarEngineManager.getInstance().appDeeplinkOpenURI(data);
        } else {
            Log.d("Demo", "onCreate Deeplink appDeeplinkOpenURI not found uri");
        }
    }

    private void initViews() {
        btnTrackEvent = findViewById(R.id.btnTrackEvent);
        btnReportEvent = findViewById(R.id.btnReportEvent);
        btnUserInit = findViewById(R.id.btnUserInit);
        btnAsyncFetchRemoteConfig = findViewById(R.id.btnAsyncFetchRemoteConfig);
    }

    private void setupClickListeners() {
        btnTrackEvent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Log.d("Demo", "trackEvent click");

                JSONObject customEventData = new JSONObject();
                try {
                    //开发者自定义Json格式上报事件属性
                    customEventData.put("key1","value1");
                    customEventData.put("key2","value2");
                } catch (JSONException e) {
                }
                SECustomEventModel seCustomEventModel = new SECustomEventModel("test_eventName",null,customEventData);
                SolarEngineManager.getInstance().track(seCustomEventModel);

            }
        });

        btnReportEvent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Log.d("Demo", "reportEvent click");
                SolarEngineManager.getInstance().reportEventImmediately();
            }
        });

        btnUserInit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Log.d("Demo", "userInit click");

                JSONObject properties = new JSONObject();
                try {
                    //开发者自定义Json格式事件属性
                    properties.put("userName","xiaoming");
                    properties.put("userLevel","1");
                } catch (JSONException e) {
                }
                SolarEngineManager.getInstance().userInit(properties);
            }
        });

        btnAsyncFetchRemoteConfig.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Log.d("Demo", "asyncFetchRemoteConfig click.");

//                RemoteConfigManager.getInstance().asyncFetchRemoteConfig("test_banner_new", new OnRemoteConfigReceivedData() {
//                    @Override
//                    public void onResult(Object o) {
//                        Log.d("Demo", "asyncFetchRemoteConfig result : " + (o == null ? "null" : o.toString()));
//                    }
//                });

                RemoteConfigManager.getInstance().asyncFetchRemoteConfig(new OnRemoteConfigReceivedGenericsData<JSONObject>() {
                    @Override
                    public void onResult(JSONObject result) {
                        Log.d("Demo", "asyncFetchRemoteConfig result : " + (result == null ? "null" : result.toString()));
                    }
                });

            }
        });
    }
}