package com.se.solarenginedemo;

import android.app.Application;
import android.content.Context;
import android.util.Log;

//import com.se.cor.DeepLinkCallBack;
////import com.se.core.DeferredDeepLinkCallback;
//import com.se.core.OnAttributionListener;
//import com.se.core.OnInitializationCallback;
//import com.se.core.SolarEngineConfig;
//import com.se.core.SolarEngineManager;
//import com.se.core.config.RemoteConfig;
//import com.se.core.infos.DeeplinkInfo;
//import com.se.core.infos.PresetEventType;

import com.reyun.solar.engine.SolarEngineConfig;
import com.reyun.solar.engine.SolarEngineManager;

import com.reyun.solar.engine.DeepLinkCallBack;
import com.reyun.solar.engine.OnAttributionListener;
import com.reyun.solar.engine.OnInitializationCallback;
import com.reyun.solar.engine.config.RemoteConfig;
import com.reyun.solar.engine.infos.DeeplinkInfo;
import com.reyun.solar.engine.infos.PresetEventType;

import org.json.JSONException;
import org.json.JSONObject;

public class MainApplication extends Application {
    @Override
    public void onCreate() {
        super.onCreate();

        String appkey = "";

        Context context = getApplicationContext();
        SolarEngineManager.getInstance().preInit(context, appkey);
        //配置SDK config
        SolarEngineConfig.Builder builder = new SolarEngineConfig.Builder();
        //配置控制台日志
        builder.logEnabled();

        //配置在线参数
        RemoteConfig remoteConfig = new RemoteConfig();
        //设置是否允许使用在线参数
        remoteConfig.setEnable(true);
        builder.withRemoteConfig(remoteConfig);
        SolarEngineManager.getInstance().setDeepLinkCallback(new DeepLinkCallBack() {
            @Override
            public void onReceived(int code, DeeplinkInfo deeplinkInfo) {
                Log.d("Demo", "DeepLinkCallback code : " + code);
                Log.d("Demo", "DeepLinkCallback deeplinkInfo : " + (deeplinkInfo == null ? "null" : deeplinkInfo.toString()));

            }
        });
        SolarEngineConfig config = builder.build();
        config.setOnAttributionListener(new OnAttributionListener() {
            @Override
            public void onAttributionSuccess(JSONObject attribution) {
                Log.d("Demo", "onAttributionSuccess: " + attribution.toString());
            }

            @Override
            public void onAttributionFail(int errorCode) {
                Log.d("Demo", "onAttributionFail: " + errorCode);
            }
        });

        Log.d("Demo", "SolarEngine SDK initialize called .");


        JSONObject customEventData = new JSONObject();
        try {
            //开发者自定义Json格式上报事件属性
            customEventData.put("key1_appInstall", "value1");
            customEventData.put("key2_appInstall", "value2");
        } catch (JSONException e) {
        }
        SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.AppInstall, customEventData);
        //初始化SDK
        SolarEngineManager.getInstance().initialize(context, appkey, config, new OnInitializationCallback() {
            @Override
            public void onInitializationCompleted(int code) {
                Log.d("Demo", "onInitializationCompleted = " + code);
            }
        });
    }
}
