
class SolarEngineSDK {




    constructor() {

        this._sub_lib_version = "1.0.2";

        this._initCallBack = null;
        this._attributionCallback = null;
        this._delayDeeplinkCallback = null;
        this._deeplinkCallback = null;
    }
    // Check if the platform is native
    _isNativePlatform() {
        if ((this._isIOS() || this._isAndroid())) {
            return true;
        } else {
            return false;
        }
    }
    _isIOS() {
        if (cc.sys.isNative && cc.sys.os === 'iOS') {
            return true;
        } else {
            return false;
        }
    }
    _isAndroid() {
        if (cc.sys.isNative && cc.sys.os === 'Android') {
            return true;
        } else {
            return false;
        }
    }

    preInitSDK(appkey) {
        if (this._isNativePlatform()) {
            if (this._isAndroid()) {
                jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'preInitSDK', '(Ljava/lang/String;)V', appkey);
            } else if (this._isIOS()) {
                jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'preInitSDK:', appkey);
            }
        }
    }

    initSDKCallback(callback) {
        this._initCallBack = callback;
        console.log("__initCallback .... 赋值.....")
    }

    attributionCallback(callback) {
        this._attributionCallback = callback;
    }

    delayDeeplinkCallback(callback) {
        this._delayDeeplinkCallback = callback;
    }

    deeplinkCallback(callback) {
        this._deeplinkCallback = callback;
    }

    _addNativeCallBack() {
        let w = window;
        let that = this
        w.__se__initCallback = function (data) {
            console.log("__initCallback .... 0")
            console.log(data)
            let properties = JSON.parse(data);
            if (that._initCallBack != null) {
                that._initCallBack(properties.code)
            } else {
                console.log("__initCallback ... not found")
            }
        };
        w.__se__attributionCallback = function (data) {
            console.log("__se__attributionCallback .... 0")
            console.log(data)
            let properties = JSON.parse(data);
            if (that._attributionCallback != null) {
                that._attributionCallback(properties)
            }

        };
        w.__se__deeplinkCallback = function (data) {
            console.log("__se__deeplinkCallback .... 0")
            console.log(data)
            let properties = JSON.parse(data);
            if (that._deeplinkCallback != null) {
                that._deeplinkCallback(properties)
            }
        };
        w.__se__delayDeeplinkCallback = function (data) {
            console.log("__se__delayDeeplinkCallback .... 0")
            console.log(data)
            let properties = JSON.parse(data);
            if (that._delayDeeplinkCallback != null) {
                that._delayDeeplinkCallback(properties)
            }
        };
    }



    initSDK(appkey, config) {

        this._addNativeCallBack();

        config.sub_lib_version = this._sub_lib_version

        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'initSDKWithConfig', '(Ljava/lang/String;Ljava/lang/String;)V', appkey, JSON.stringify(config));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'initSDK:withConfig:', appkey, JSON.stringify(config));
        } else {
            console.log("initInstanceForNative not found .")
        }
    }

    setVisitorId(visitorId) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setVisitorId', '(Ljava/lang/String;)V', visitorId);
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'setVisitorId:', visitorId);
        }
    }

    getVisitorId() {
        if (this._isAndroid()) {
            return jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'getVisitorId', '()Ljava/lang/String;');
        } else if (this._isIOS()) {
            return jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'getVisitorId');
        }
    }
    getDistinctId() {
        if (this._isAndroid()) {
            return jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'getDistinctId', '()Ljava/lang/String;');
        } else if (this._isIOS()) {
            return jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'getDistinctId');
        }
    }

    login(accountId) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'login', '(Ljava/lang/String;)V', accountId);
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'login:', accountId);
        }
    }

    getAccountId() {
        if (this._isAndroid()) {
            return jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'getAccountId', '()Ljava/lang/String;');
        } else if (this._isIOS()) {
            return jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'getAccountId');
        }
    }

    logout() {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'logout', '()V');
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'logout');
        }
    }

    setGaid(gaid) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setGaid', '(Ljava/lang/String;)V', gaid);
        }
    }

    setChannel(channel) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setChannel', '(Ljava/lang/String;)V', channel);
        }
    }

    reportEventImmediately() {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'reportEventImmediately', '()V');
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'reportEventImmediately');
        }
    }

    getPresetProperties() {
        let properties = '{}';
        if (this._isAndroid()) {
            properties = jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'getPresetProperties', '()Ljava/lang/String;');
        } else if (this._isIOS()) {
            properties = jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'getPresetProperties');
        }
        return JSON.parse(properties);
    }

    setGDPRArea(isGDPRArea) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setGDPRArea', '(Ljava/lang/String;)V', isGDPRArea.toString());
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'setGDPRArea:', isGDPRArea.toString());
        }
    }

    setPresetEventProperties(eventType, properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setPresetEventProperties', '(Ljava/lang/String;Ljava/lang/String;)V', eventType.toString(), JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'setPresetEventProperties:withProperties:', eventType.toString(), JSON.stringify(properties));
        }
    }

    getAttribution() {
        let properties = '{}';
        if (this._isAndroid()) {
            properties = jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'getAttribution', '()Ljava/lang/String;');
        } else if (this._isIOS()) {
            properties = jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'getAttribution');
        }
        return JSON.parse(properties);
    }

    setSuperProperties(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setSuperProperties', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'setSuperProperties:', JSON.stringify(properties));
        }
    }

    unsetSuperProperty(key) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'unsetSuperProperty', '(Ljava/lang/String;)V', key);
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'unsetSuperProperty:', key);
        }
    }

    clearSuperProperties() {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'clearSuperProperties', '()V');
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'clearSuperProperties');
        }
    }

    trackCustom(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackCustom', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackCustom:', JSON.stringify(properties));
        }
    }

    trackPurchase(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackPurchase', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackPurchase:', JSON.stringify(properties));
        }
    }

    trackAdImpression(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackAdImpression', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackAdImpression:', JSON.stringify(properties));
        }
    }

    trackAdClick(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackAdClick', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackAdClick:', JSON.stringify(properties));
        }
    }

    trackAppAttr(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackAppAttr', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackAppAttr:', JSON.stringify(properties));
        }
    }

    trackRegister(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackRegister', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackRegister:', JSON.stringify(properties));
        }
    }
    trackLogin(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackLogin', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackLogin:', JSON.stringify(properties));
        }
    }
    trackOrder(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackOrder', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackOrder:', JSON.stringify(properties));
        }
    }

    eventStart(eventName) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'eventStart', '(Ljava/lang/String;)V', eventName);
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'eventStart:', eventName);
        }
    }

    eventFinish(eventName, properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'eventFinish', '(Ljava/lang/String;Ljava/lang/String;)V', eventName, JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'eventFinish:customProperties:', eventName, JSON.stringify(properties));
        }
    }

    trackFirstEvent(firstCheckId, eventName, properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'trackFirstEvent', '(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V', firstCheckId, eventName, JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'trackFirstEvent:eventName:properties:', firstCheckId, eventName, JSON.stringify(properties));
        }
    }


    userInit(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'userInit', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'userInit:', JSON.stringify(properties));
        }
    }

    userUpdate(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'userUpdate', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'userUpdate:', JSON.stringify(properties));
        }
    }
    userAdd(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'userAdd', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'userAdd:', JSON.stringify(properties));
        }
    }

    userUnset(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'userUnset', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'userUnset:', JSON.stringify(properties));
        }
    }

    userAppend(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'userAppend', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'userAppend:', JSON.stringify(properties));
        }
    }

    userDelete(type) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'userDelete', '(Ljava/lang/String;)V', type);
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'userDelete:', type);
        }
    }

    setDefaultConfig(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setDefaultConfig', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'setDefaultConfig:', JSON.stringify(properties));
        }
    }

    setRemoteConfigEventProperties(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setRemoteConfigEventProperties', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'setRemoteConfigEventProperties:', JSON.stringify(properties));
        }
    }

    setRemoteConfigUserProperties(properties) {
        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'setRemoteConfigUserProperties', '(Ljava/lang/String;)V', JSON.stringify(properties));
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'setRemoteConfigUserProperties:', JSON.stringify(properties));
        }
    }

    fastFetchRemoteConfigWithKey(key) {
        let properties = '{}';
        if (this._isAndroid()) {
            properties = jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'fastFetchRemoteConfigWithKey', '(Ljava/lang/String;)Ljava/lang/String;', key);
        } else if (this._isIOS()) {
            properties = jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'fastFetchRemoteConfigWithKey:', key);
        }
        console.log("fastFetchRemoteConfigWithKey ...result");
        console.log(properties)
        let object = JSON.parse(properties)
        return object.data;
    }

    fastFetchRemoteConfig() {
        let properties = '{}';
        if (this._isAndroid()) {
            properties = jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'fastFetchRemoteConfig', '()Ljava/lang/String;');
        } else if (this._isIOS()) {
            properties = jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'fastFetchRemoteConfig');
        }
        return JSON.parse(properties);
    }

    asyncFetchRemoteConfigWithKey(key, callback) {

        if (this._isNativePlatform()) {

            let w = window;
            let that = this
            w.__se__asyncFetchRemoteConfigWithKeyCallback = function (data) {
                console.log("__asyncFetchRemoteConfigWithKeyCallback .... 0")
                console.log(data)
                let object = JSON.parse(data)
                if (callback != null) {
                    callback(object.data)
                }
            };
        }

        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'asyncFetchRemoteConfigWithKey', '(Ljava/lang/String;)V', key);
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'asyncFetchRemoteConfigWithKey:', key);
        }
    }
    asyncFetchRemoteConfig(callback) {

        if (this._isNativePlatform()) {

            let w = window;
            let that = this
            w.__se__asyncFetchRemoteConfigCallback = function (data) {
                console.log("__asyncFetchRemoteConfigCallback .... 0")
                console.log(data)
                let object = JSON.parse(data)
                if (callback != null) {
                    callback(object)
                }
            };
        }

        if (this._isAndroid()) {
            jsb.reflection.callStaticMethod('com/cocos/game/SECocosCreatorProxyApi', 'asyncFetchRemoteConfig', '()V');
        } else if (this._isIOS()) {
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'asyncFetchRemoteConfig');
        }
    }

    updatePostbackConversionValue(fineValue, callback) {
        if (this._isIOS()) {
            let w = window;
            w.__se__updatePostbackConversionValueCallback = function (result) {
                console.log("__updatePostbackConversionValueCallback ....")
                console.log(result)
                let data = JSON.parse(result);
                callback(result.code)
            };
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'updatePostbackConversionValue:', fineValue.toString());
        }
    }

    updatePostbackConversionAndCoarseValue(fineValue, coarseValue, callback) {
        if (this._isIOS()) {
            let w = window;
            w.__se__updatePostbackConversionValueCallback = function (result) {
                console.log("__updatePostbackConversionValueCallback ....")
                console.log(result)
                let data = JSON.parse(result);
                callback(result.code)
            };
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'updatePostbackConversionAndCoarseValue:coarseValue:', fineValue.toString(), coarseValue);
        }
    }

    updatePostbackConversionAndCoarseValueAndlockWindow(fineValue, coarseValue, lockWindow, callback) {
        if (this._isIOS()) {
            let w = window;
            w.__se__updatePostbackConversionValueCallback = function (result) {
                console.log("__updatePostbackConversionValueCallback ....")
                console.log(result)
                let data = JSON.parse(result);
                callback(result.code)
            };
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'updatePostbackConversionAndCoarseValueAndlockWindow:coarseValue:lockWindow:', fineValue.toString(), coarseValue, lockWindow.toString());
        }
    }

    requestTrackingAuthorization(callback) {
        if (this._isIOS()) {
            let w = window;
            w.__se__requestTrackingAuthorizationCallback = function (result) {
                console.log("__requestTrackingAuthorizationCallback ....")
                console.log(result)
                let data = JSON.parse(result);
                callback(result.code)
            };
            jsb.reflection.callStaticMethod('SECocosCreatorProxyApi', 'requestTrackingAuthorization');
        }
    }



}

// module.exports = SolarEngineSDK;
// // export default SolarEngineSDK;
// window['SolarEngineSDK'] = SolarEngineSDK;


(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
        typeof define === 'function' && define.amd ? define(factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.SESDK = factory());
})(this, (function () {
    'use strict';
    return new SolarEngineSDK();

}));