package org.cocos2dx.lua;

import android.content.Context;
import android.os.Looper;
import android.renderscript.RSIllegalArgumentException;
import android.util.Log;

import org.cocos2dx.lib.Cocos2dxActivity;
import org.cocos2dx.lib.Cocos2dxLuaJavaBridge;
import org.json.JSONException;
import org.json.JSONObject;
import android.text.TextUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;

import com.reyun.remote.config.OnRemoteConfigReceivedGenericsData;
import com.reyun.remote.config.RemoteConfigManager;
import com.reyun.remote.config.OnRemoteConfigReceivedData;
import com.reyun.solar.engine.DeepLinkCallBack;
import com.reyun.solar.engine.DeferredDeepLinkCallback;
import com.reyun.solar.engine.OnAttributionListener;
import com.reyun.solar.engine.SolarEngineManager;
import com.reyun.solar.engine.SolarEngineConfig;
import com.reyun.solar.engine.OnInitializationCallback;
import com.reyun.solar.engine.config.CustomDomain;
import com.reyun.solar.engine.config.RemoteConfig;
import com.reyun.solar.engine.infos.DeeplinkInfo;
import com.reyun.solar.engine.infos.PresetEventType;
import com.reyun.solar.engine.infos.SEAdClickEventModel;
import com.reyun.solar.engine.infos.SEAdImpEventModel;
import com.reyun.solar.engine.infos.SEAppReEngagementModel;
import com.reyun.solar.engine.infos.SEAppRegisterFirstEventModel;
import com.reyun.solar.engine.infos.SEAttrEventModel;
import com.reyun.solar.engine.infos.SECustomEventModel;
import com.reyun.solar.engine.infos.SECustomFirstEventModel;
import com.reyun.solar.engine.infos.SELoginEventModel;
import com.reyun.solar.engine.infos.SEOrderEventModel;
import com.reyun.solar.engine.infos.SEPurchaseEventModel;
import com.reyun.solar.engine.infos.SERegisterEventModel;
import com.reyun.solar.engine.tracker.SEUserDeleteType;
import com.reyun.solar.engine.SeSdkSource;

public class SolarEngineProxy {

	private static final String TAG = "SE.CocosLua";
	private static JSONObject jsonObjectFromString(String s) {
		try {
			JSONObject jsonObject = new JSONObject(s);
			return jsonObject;
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return new JSONObject();
	}
	public static void preInit(String appKey) {
		SolarEngineManager.getInstance().preInit(Cocos2dxActivity.getContext(),appKey);
	}

	public static void initWithConfig(String options) {
		SolarEngineConfig.Builder builder = new SolarEngineConfig.Builder();

        Log.d(TAG,"initWithConfig options: "+options);

        String appKey = null;
		try {
			JSONObject configObj = null;
			if (options != null) {
				configObj = new JSONObject(options);
			} else {
				configObj = new JSONObject();
			}

			if (configObj.has("appKey")) {
				appKey = configObj.optString("appKey");
			}

			// 基础配置
			if (configObj.has("logEnabled")) {
				boolean enableLog = configObj.optBoolean("logEnabled");
				if (enableLog) {
					builder.logEnabled();
				}
			}

			if (configObj.has("isDebugModel")) {
				boolean isDebugModel = configObj.optBoolean("isDebugModel");
				builder.isDebugModel(isDebugModel);
			}

			if (configObj.has("isGDPRArea")) {
				boolean isGDPRArea = configObj.optBoolean("isGDPRArea");
				builder.isGDPRArea(isGDPRArea);
			}

			if (configObj.has("setCoppaEnabled")) {
				boolean setCoppaEnabled = configObj.optBoolean("setCoppaEnabled");
				builder.setCoppaEnabled(setCoppaEnabled);
			}

			if (configObj.has("setKidsAppEnabled")) {
				boolean setKidsAppEnabled = configObj.optBoolean("setKidsAppEnabled");
				builder.setKidsAppEnabled(setKidsAppEnabled);
			}

			if (configObj.has("enable2GReporting")) {
				boolean enable2GReporting = configObj.optBoolean("enable2GReporting");
				builder.enable2GReporting(enable2GReporting);
			}

			if (configObj.has("enableDeferredDeeplink")) {
				boolean enableDeferredDeeplink = configObj.optBoolean("enableDeferredDeeplink");
				builder.enableDelayDeeplink(enableDeferredDeeplink);
			}

			if (configObj.has("adPersonalizationEnabled")) {
				boolean adPersonalizationEnabled = configObj.optBoolean("adPersonalizationEnabled");
				builder.adPersonalizationEnabled(adPersonalizationEnabled);
			}

			if (configObj.has("adUserDataEnabled")) {
				boolean adUserDataEnabled = configObj.optBoolean("adUserDataEnabled");
				builder.adUserDataEnabled(adUserDataEnabled);
			}

			if (configObj.has("fbAppID")) {
				String fbAppID = configObj.optString("fbAppID");
				if (!TextUtils.isEmpty(fbAppID)) {
					builder.setFbAppID(fbAppID);
				}
			}
			if (configObj.has("supportMultiProcess")) {
				boolean result = configObj.optBoolean("supportMultiProcess");
				builder.supportMultiProcess(result);
			}
			if (configObj.has("isOAIDEnabled")) {
				boolean result = configObj.optBoolean("isOAIDEnabled");
				builder.isOAIDEnabled(result);
			}
			if (configObj.has("isImeiEnabled")) {
				boolean result = configObj.optBoolean("isImeiEnabled");
				builder.isImeiEnabled(result);
			}
			if (configObj.has("isAndroidIDEnabled")) {
				boolean result = configObj.optBoolean("isAndroidIDEnabled");
				builder.isAndroidIDEnabled(result);
			}
			if (configObj.has("enableIPV6Address")) {
				boolean result = configObj.optBoolean("enableIPV6Address");
				builder.enableIPV6Address(result);
			}

			String subLibVersion = "";
			if (configObj.has("sub_lib_version")) {
				subLibVersion = (String) configObj.optString("sub_lib_version");
			}
			SeSdkSource seSdkSource = new SeSdkSource();
			seSdkSource.setSubLibVersion(subLibVersion);
			seSdkSource.setSdkType("cocos2d-lua");
			SolarEngineManager.getInstance().setSeSdkSource(seSdkSource);

			if (configObj.has("remoteConfig")) {
				JSONObject remoteConfigJson = configObj.optJSONObject("remoteConfig");
				if (remoteConfigJson != null) {
					RemoteConfig remoteConfig = new RemoteConfig();
					if (remoteConfigJson.has("enable")) {
						boolean enable = remoteConfigJson.optBoolean("enable");
						remoteConfig.setEnable(enable);
					}
					if (remoteConfigJson.has("mergeType")) {
						int mergeType = remoteConfigJson.optInt("mergeType");
						if (mergeType == 1) {
							remoteConfig.setMergeType(RemoteConfig.MergeType.WITH_USER);
						} else {
							remoteConfig.setMergeType(RemoteConfig.MergeType.WITH_CACHE);
						}
					}
					if (remoteConfigJson.has("customIDProperties")) {
						JSONObject customIDProperties = remoteConfigJson.optJSONObject("customIDProperties");
						if (customIDProperties != null) {
							remoteConfig.setCustomIDProperties(customIDProperties);
						}
					}
					if (remoteConfigJson.has("customIDEventProperties")) {
						JSONObject customIDEventProperties = remoteConfigJson.optJSONObject("customIDEventProperties");
						if (customIDEventProperties != null) {
							remoteConfig.setCustomIDEventProperties(customIDEventProperties);
						}
					}
					if (remoteConfigJson.has("customIDUserProperties")) {
						JSONObject customIDUserProperties = remoteConfigJson.optJSONObject("customIDUserProperties");
						if (customIDUserProperties != null) {
							remoteConfig.setCustomIDUserProperties(customIDUserProperties);
						}
					}
					builder.withRemoteConfig(remoteConfig);
				}
			}

			boolean enableCustomDomain = false;
			if (configObj.has("customDomain")) {
				JSONObject customDomainJson = configObj.optJSONObject("customDomain");
				if (customDomainJson != null) {
					CustomDomain customDomain = new CustomDomain();
					if (customDomainJson.has("enable")) {
						enableCustomDomain = customDomainJson.optBoolean("enable");
					}
				}
			}

			if (configObj.has("customDomain") && enableCustomDomain) {
				Log.d(TAG,configObj.toString());
				JSONObject customDomainJson = configObj.optJSONObject("customDomain");
				if (customDomainJson != null) {
					CustomDomain customDomain = new CustomDomain();
					if (customDomainJson.has("enable")) {
						boolean enable = customDomainJson.optBoolean("enable");
						customDomain.setEnable(enable);
					}
					if (customDomainJson.has("receiverDomain")) {
						String receiverDomain = customDomainJson.optString("receiverDomain");
						customDomain.setReceiverDomain(receiverDomain);
					}
					if (customDomainJson.has("ruleDomain")) {
						String ruleDomain = customDomainJson.optString("ruleDomain");
						customDomain.setRuleDomain(ruleDomain);
					}
					if (customDomainJson.has("receiverTcpHost")) {
						String tcpReceiverHost = customDomainJson.optString("receiverTcpHost");
						customDomain.setTcpReceiverHost(tcpReceiverHost);
					}
					if (customDomainJson.has("ruleTcpHost")) {
						String tcpRuleHost = customDomainJson.optString("ruleTcpHost");
						customDomain.setTcpRuleHost(tcpRuleHost);
					}
					if (customDomainJson.has("gatewayTcpHost")) {
						String tcpGatewayHost = customDomainJson.optString("gatewayTcpHost");
						customDomain.setTcpGatewayHost(tcpGatewayHost);
					}
					builder.withCustomDomain(customDomain);
				}
			}
		} catch (Exception e) {
			Log.e(TAG, "Error parsing config: " + e.getMessage());
		}

		SolarEngineConfig config = builder.build();

		config.setOnAttributionListener(new OnAttributionListener() {
			@Override
			public void onAttributionSuccess(JSONObject jsonObject) {
				JSONObject attrResult = new JSONObject();
				try {
					if (jsonObject != null) {
						attrResult.put("code", 0);
						attrResult.put("data", jsonObject);
					} else {
						attrResult.put("code", -1);
					}
				} catch (JSONException e) {
					Log.e(TAG,"onAttributionFail JSONException : "+e);
				}
				if (!TextUtils.isEmpty(attrCallbackName)) {
					try {
						Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(attrCallbackName, attrResult.toString());
						Log.d(TAG, "Successfully called attribution callback: " + attrCallbackName);
					} catch (Exception e) {
						Log.e(TAG, "Failed to call attribution callback: " + e.getMessage());
					}
				}
			}
			@Override
			public void onAttributionFail(int i) {
				JSONObject attrResult = new JSONObject();
				try {
					attrResult.put("code", i);
				} catch (JSONException e) {
					Log.e(TAG,"onAttributionFail JSONException : "+e);
				}
				if (!TextUtils.isEmpty(attrCallbackName)) {
					try {
						Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(attrCallbackName, attrResult.toString());
						Log.d(TAG, "Successfully called attribution fail callback: " + attrCallbackName);
					} catch (Exception e) {
						Log.e(TAG, "Failed to call attribution fail callback: " + e.getMessage());
					}
				}
			}
		});

		SolarEngineManager.getInstance().setDeferredDeepLinkCallback(new DeferredDeepLinkCallback() {
			@Override
			public void onReceivedSuccess(JSONObject jsonObject) {
				JSONObject attrResult = new JSONObject();
				try {
					if (jsonObject != null) {
						attrResult.put("code", 0);
						attrResult.put("data", jsonObject);
					} else {
						attrResult.put("code", -1);
					}
				} catch (JSONException e) {
					Log.e(TAG,"onAttributionFail JSONException : "+e);
				}
				if (!TextUtils.isEmpty(deferredDeeplinkCallbackName)) {
					try {
						Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(deferredDeeplinkCallbackName, attrResult.toString());
						Log.d(TAG, "Successfully called deferred deeplink success callback: " + deferredDeeplinkCallbackName);
					} catch (Exception e) {
						Log.e(TAG, "Failed to call deferred deeplink success callback: " + e.getMessage());
					}
				}
			}
			@Override
			public void onReceivedFailed(int i) {
				JSONObject attrResult = new JSONObject();
				try {
					attrResult.put("code", i);
				} catch (JSONException e) {
					Log.e(TAG,"onAttributionFail JSONException : "+e);
				}
				if (!TextUtils.isEmpty(deferredDeeplinkCallbackName)) {
					try {
						Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(deferredDeeplinkCallbackName, attrResult.toString());
						Log.d(TAG, "Successfully called deferred deeplink fail callback: " + deferredDeeplinkCallbackName);
					} catch (Exception e) {
						Log.e(TAG, "Failed to call deferred deeplink fail callback: " + e.getMessage());
					}
				}
			}
		});

		SolarEngineManager.getInstance().setDeepLinkCallback(new DeepLinkCallBack() {
			@Override
			public void onReceived(int i, DeeplinkInfo deeplinkInfo) {

				JSONObject callBackResult = new JSONObject();
				JSONObject data = new JSONObject();
				try {
					if (deeplinkInfo != null) {
						data.put("sedpLink", deeplinkInfo.sedpLink);
						data.put("turlId", deeplinkInfo.turlId);
						data.put("from", deeplinkInfo.from);
						data.put("baseUrl", deeplinkInfo.baseURL);
						data.put("url", deeplinkInfo.url);
						data.put("customParams", deeplinkInfo.customParams);
					}
				} catch (JSONException e) {
					Log.e(TAG,"onReceived JSONException : "+e);
				}

				try {
					callBackResult.put("code", i);
					callBackResult.put("data", data);
				} catch (JSONException e) {
					Log.e(TAG,"onReceived JSONException : "+e);
				}
				if (!TextUtils.isEmpty(deeplinkCallbackName)) {
					try {
						Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(deeplinkCallbackName, callBackResult.toString());
						Log.d(TAG, "Successfully called deeplink callback: " + deeplinkCallbackName);
					} catch (Exception e) {
						Log.e(TAG, "Failed to call deeplink callback: " + e.getMessage());
					}
				}
			}
		});

		SolarEngineManager.getInstance().initialize(Cocos2dxActivity.getContext(), appKey, config, new OnInitializationCallback() {
			@Override
			public void onInitializationCompleted(int i) {
				// 调用 Lua 回调函数
				if (!TextUtils.isEmpty(initCallbackName)) {
					try {
						Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(initCallbackName, String.valueOf(i));
						Log.d(TAG, "Successfully called Lua callback: " + initCallbackName + " with code: " + i);
					} catch (Exception e) {
						Log.e(TAG, "Failed to call Lua callback: " + e.getMessage());
					}
				} else {
					Log.w(TAG, "No init callback set, skipping Lua callback");
				}
			}
		});
	}

	// 设置初始化回调
	private static String initCallbackName = "";
	private static String attrCallbackName = "";
	private static String deeplinkCallbackName = "";
	private static String deferredDeeplinkCallbackName = "";
	private static String remoteConfigCallbackName = "";
	private static String remoteConfigAllCallbackName = "";
	
	public static void setInitCallback(String callbackName) {
		initCallbackName = callbackName;
	}

	// 设置深度链接回调
	public static void setDeeplinkCallback(String callbackName) {
		deeplinkCallbackName = callbackName;
	}

	// 设置延迟深度链接回调
	public static void setDeferredDeeplinkCallback(String callbackName) {
		deferredDeeplinkCallbackName = callbackName;
	}

	// 设置归因回调
	public static void setAttributionCallback(String callbackName) {
		attrCallbackName = callbackName;
	}

	// 设置远程配置回调
	public static void setRemoteConfigCallback(String callbackName) {
		remoteConfigCallbackName = callbackName;
	}

	// 设置远程配置全部回调
	public static void setRemoteConfigAllCallback(String callbackName) {
		remoteConfigAllCallbackName = callbackName;
	}

	public static String getDistinctId() {
		try {
			String distinctId = SolarEngineManager.getInstance().getDistinctId();
			return distinctId != null ? distinctId : "";
		} catch (Exception e) {
			Log.e(TAG, "Error getting distinct ID: " + e.getMessage());
			return "";
		}
	}
	// 用户管理 API - 扩展
	public static void setVisitorID(String visitorId) {
		try {
			SolarEngineManager.getInstance().setVisitorID(visitorId);
		} catch (Exception e) {
			Log.e(TAG, "Error setting visitor ID: " + e.getMessage());
		}
	}

	public static String getVisitorID() {
		try {
			String visitorID = SolarEngineManager.getInstance().getVisitorID();
			return visitorID != null ? visitorID : "";
		} catch (Exception e) {
			Log.e(TAG, "Error getting visitor ID: " + e.getMessage());
			return "";
		}
	}

	public static void loginWithAccountID(String accountId) {
		try {
			SolarEngineManager.getInstance().login(accountId);
		} catch (Exception e) {
			Log.e(TAG, "Error login with account ID: " + e.getMessage());
		}
	}
	public static String getAccountID() {
		try {
			String accountID = SolarEngineManager.getInstance().getAccountID();
			return accountID != null ? accountID : "";
		} catch (Exception e) {
			Log.e(TAG, "Error getting account ID: " + e.getMessage());
			return "";
		}
	}
	public static void logout() {
		try {
			SolarEngineManager.getInstance().logout();
		} catch (Exception e) {
			Log.e(TAG, "Error logout: " + e.getMessage());
		}
	}

	public static String getPresetProperties() {
		try {
			JSONObject presetProps = SolarEngineManager.getInstance().getPresetProperties();
			return presetProps != null ? presetProps.toString() : "{}";
		} catch (Exception e) {
			Log.e(TAG, "Error getting preset properties: " + e.getMessage());
			return "{}";
		}
	}

	// 添加 trackEvent 方法，与 Lua 代码中的调用保持一致
	public static void trackEvent(String eventName, String customProperties) {
		try {
			SECustomEventModel seCustomEventModel = new SECustomEventModel();
			if (customProperties != null) {
				seCustomEventModel.setCustomProperties(new JSONObject(customProperties));
			}
			if (!TextUtils.isEmpty(eventName)) {
				seCustomEventModel.setCustomEventName(eventName);
			}
			SolarEngineManager.getInstance().track(seCustomEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking event: " + e.getMessage());
		}
	}
	public static void trackIAP(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();

			SEPurchaseEventModel sePurchaseEventModel = new SEPurchaseEventModel();
			if (props.has("productId")) {
				sePurchaseEventModel.setProductId(props.optString("productId"));
			}
			if (props.has("productName")) {
				sePurchaseEventModel.setProductName(props.optString("productName"));
			}
			if (props.has("productCount")) {
				sePurchaseEventModel.setProductNum(props.optInt("productCount"));
			}
			if (props.has("orderId")) {
				sePurchaseEventModel.setOrderId(props.optString("orderId"));
			}
			if (props.has("payAmount")) {
				sePurchaseEventModel.setPayAmount(props.optDouble("payAmount"));
			}
			if (props.has("currency")) {
				sePurchaseEventModel.setCurrencyType(props.optString("currency"));
			}
			if (props.has("payType")) {
				sePurchaseEventModel.setPayType(props.optString("payType"));
			}
			if (props.has("payStatus")) {
				sePurchaseEventModel.setPayStatus(props.optInt("payStatus"));
			}
			if (props.has("failReason")) {
				sePurchaseEventModel.setFailReason(props.optString("failReason"));
			}
			if (props.has("customProperties")) {
				sePurchaseEventModel.setCustomProperties(props.getJSONObject("customProperties"));
			}
			SolarEngineManager.getInstance().trackPurchase(sePurchaseEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking purchase event: " + e.getMessage());
		}
	}
	public static void trackAdImpression(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();

			SEAdImpEventModel seAdImpEventModel = new SEAdImpEventModel();
			if (props.has("adType")) {
				seAdImpEventModel.setAdType(props.optInt("adType"));
			}
			if (props.has("adNetworkPlatform")) {
				seAdImpEventModel.setAdNetworkPlatform(props.optString("adNetworkPlatform"));
			}
			if (props.has("adNetworkAppId")) {
				seAdImpEventModel.setAdNetworkAppID(props.optString("adNetworkAppId"));
			}
			if (props.has("adNetworkPlacementId")) {
				seAdImpEventModel.setAdNetworkADID(props.optString("adNetworkPlacementId"));
			}
			if (props.has("ecpm")) {
				seAdImpEventModel.setEcpm((double) props.optDouble("ecpm"));
			}
			if (props.has("currency")) {
				seAdImpEventModel.setCurrencyType(props.optString("currency"));
			}
			if (props.has("mediationPlatform")) {
				seAdImpEventModel.setMediationPlatform(props.optString("mediationPlatform"));
			}
			if (props.has("rendered")) {
				seAdImpEventModel.setRenderSuccess(props.optBoolean("rendered"));
			}
			if (props.has("customProperties")) {
				seAdImpEventModel.setCustomProperties(props.getJSONObject("customProperties"));
			}

			SolarEngineManager.getInstance().trackAdImpression(seAdImpEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking ad impression: " + e.getMessage());
		}
	}

	public static void trackAdClick(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();

			SEAdClickEventModel seAdClickEventModel = new SEAdClickEventModel();
			if (props.has("adType")) {
				seAdClickEventModel.setAdType(props.optInt("adType"));
			}
			if (props.has("adNetworkPlatform")) {
				seAdClickEventModel.setAdPlatform(props.optString("adNetworkPlatform"));
			}
			if (props.has("adNetworkPlacementId")) {
				seAdClickEventModel.setAdNetworkADID(props.optString("adNetworkPlacementId"));
			}
			if (props.has("mediationPlatform")) {
				seAdClickEventModel.setMediationPlatform(props.optString("mediationPlatform"));
			}
			if (props.has("customProperties")) {
				seAdClickEventModel.setCustomProperties(props.getJSONObject("customProperties"));
			}

			SolarEngineManager.getInstance().trackAdClick(seAdClickEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking ad click: " + e.getMessage());
		}
	}

	public static void trackAttrEvent(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();

			SEAttrEventModel seAttrEventModel = new SEAttrEventModel();
			if (props.has("adNetwork")) {
				seAttrEventModel.setAdNetwork(props.optString("adNetwork"));
			}
			if (props.has("subChannel")) {
				seAttrEventModel.setSubChannel(props.optString("subChannel"));
			}
			if (props.has("adAccountId")) {
				seAttrEventModel.setAdAccountId(props.optString("adAccountId"));
			}
			if (props.has("adAccountName")) {
				seAttrEventModel.setAdAccountName(props.optString("adAccountName"));
			}
			if (props.has("adCampaignId")) {
				seAttrEventModel.setAdCampaignId(props.optString("adCampaignId"));
			}
			if (props.has("adCampaignName")) {
				seAttrEventModel.setAdCampaignName(props.optString("adCampaignName"));
			}
			if (props.has("adOfferId")) {
				seAttrEventModel.setAdOfferId(props.optString("adOfferId"));
			}
			if (props.has("adOfferName")) {
				seAttrEventModel.setAdOfferName(props.optString("adOfferName"));
			}
			if (props.has("adCreativeId")) {
				seAttrEventModel.setAdCreativeId(props.optString("adCreativeId"));
			}
			if (props.has("adCreativeName")) {
				seAttrEventModel.setAdCreativeName(props.optString("adCreativeName"));
			}
			if (props.has("attributionPlatform")) {
				seAttrEventModel.setAttributionPlatform(props.optString("attributionPlatform"));
			}
			if (props.has("customProperties")) {
				seAttrEventModel.setCustomProperties(props.getJSONObject("customProperties"));
			}
			SolarEngineManager.getInstance().trackAttr(seAttrEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking attr event: " + e.getMessage());
		}
	}

	public static void trackLoginEvent(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();

			SELoginEventModel seLoginEventModel = new SELoginEventModel();
			if (props.has("customProperties")) {
				seLoginEventModel.setCustomProperties(props.getJSONObject("customProperties"));
			}
			if (props.has("loginType")) {
				seLoginEventModel.setLoginType(props.optString("loginType"));
			}
			if (props.has("loginStatus")) {
				seLoginEventModel.setStatus(props.optString("loginStatus"));
			}
			SolarEngineManager.getInstance().trackAppLogin(seLoginEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking login event: " + e.getMessage());
		}
	}

	public static void trackRegisterEvent(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			
			SERegisterEventModel seRegisterEventModel = new SERegisterEventModel();
			if (props.has("customProperties")) {
				seRegisterEventModel.setCustomProperties(props.getJSONObject("customProperties"));
			}
			if (props.has("registerType")) {
				seRegisterEventModel.setRegType(props.optString("registerType"));
			}
			if (props.has("registerStatus")) {
				seRegisterEventModel.setStatus(props.optString("registerStatus"));
			}
			SolarEngineManager.getInstance().trackAppRegister(seRegisterEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking register event: " + e.getMessage());
		}
	}

	public static void trackOrderEvent(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			
			SEOrderEventModel seOrderEventModel = new SEOrderEventModel();
			if (props.has("orderId")) {
				seOrderEventModel.setOrderId(props.optString("orderId"));
			}
			if (props.has("payAmount")) {
				seOrderEventModel.setPayAmount(props.optDouble("payAmount"));
			}
			if (props.has("currency")) {
				seOrderEventModel.setCurrencyType(props.optString("currency"));
			}
			if (props.has("payType")) {
				seOrderEventModel.setPayType(props.optString("payType"));
			}
			if (props.has("status")) {
				seOrderEventModel.setStatus(props.optString("status"));
			}
			if (props.has("customProperties")) {
				seOrderEventModel.setCustomProperties(props.getJSONObject("customProperties"));
			}
			SolarEngineManager.getInstance().trackOrder(seOrderEventModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking order event: " + e.getMessage());
		}
	}

	public static void trackFirstEvent(String firstCheckId, String eventName, String options) {
		try {
			JSONObject properties = null;
			if (options != null) {
				properties = stringToJSONObject(options);
			}

			if (eventName.equals("_appReg")) {
				JSONObject data = stringToJSONObject(options);
				SEAppRegisterFirstEventModel seRegisterEventModel = new SEAppRegisterFirstEventModel();
				JSONObject customProperties = data.optJSONObject("customProperties");
				if (customProperties != null) {
					seRegisterEventModel.setCustomProperties(customProperties);
				}
				String registerType = data.optString("registerType");
				if (!TextUtils.isEmpty(registerType)) {
					seRegisterEventModel.setRegType(registerType);
				}
				String registerStatus = data.optString("registerStatus");
				if (!TextUtils.isEmpty(registerStatus)) {
					seRegisterEventModel.setStatus(registerStatus);
				}
				if (!TextUtils.isEmpty(firstCheckId)) {
					seRegisterEventModel.setCheckId(firstCheckId);
				}
				SolarEngineManager.getInstance().trackFirstEvent(seRegisterEventModel);

			} else  {

				if(eventName.charAt(0) == '_') {
					Log.e(TAG, "trackFirstEvent Error:" + "trackFirstEvent api only support _appReg event and custom event.");
				}

				SECustomFirstEventModel seCustomEventModel = new SECustomFirstEventModel();
				if (properties != null) {
					seCustomEventModel.setCustomProperties(properties);
				}
				if (!TextUtils.isEmpty(eventName)) {
					seCustomEventModel.setEventName(eventName);
				}
				if (!TextUtils.isEmpty(firstCheckId)) {
					seCustomEventModel.setCheckId(firstCheckId);
				}
			}
		} catch (Exception e) {
			Log.e(TAG, "Error tracking first event: " + e.getMessage());
		}
	}

	public static void eventStart(String eventName) {
		try {
			SolarEngineManager.getInstance().eventStart(eventName);
		} catch (Exception e) {
			Log.e(TAG, "Error starting event: " + e.getMessage());
		}
	}

	public static void eventFinish(String eventName, String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			SolarEngineManager.getInstance().eventFinish(eventName, props);
		} catch (Exception e) {
			Log.e(TAG, "Error finishing event: " + e.getMessage());
		}
	}

	public static void reportEventImmediately() {
		try {
			SolarEngineManager.getInstance().reportEventImmediately();
		} catch (Exception e) {
			Log.e(TAG, "Error reporting event immediately: " + e.getMessage());
		}
	}

	public static void trackAppReEngagement(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			
			SEAppReEngagementModel seAppReEngagementModel = new SEAppReEngagementModel();
			if (props.has("customProperties")) {
				seAppReEngagementModel.setCustomProperties(props.getJSONObject("customProperties"));
			}
			// reEngagementType 和 reEngagementStatus 属性通过 customProperties 传递
			SolarEngineManager.getInstance().trackAppReEngagement(seAppReEngagementModel);
		} catch (Exception e) {
			Log.e(TAG, "Error tracking app re-engagement: " + e.getMessage());
		}
	}

	public static void setSuperProperties(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			try {
				if (properties != null) {
					Iterator<String> sIterator = props.keys();
					while (sIterator.hasNext()) {
						try {
							String key = sIterator.next();
							Object value = props.get(key);
							doProperties(Cocos2dxActivity.getContext(), key, value);
						} catch (JSONException e) {
							Log.e(TAG, "setSuperProperties JSONException : " + e);
						}
					}
				} else {
					Log.e(TAG, "setSuperProperties failed, superProperties is null!");
				}
			} catch (Exception e) {
				Log.e(TAG, "Error setting super properties: " + e.getMessage());
			}

		} catch (Exception e) {
			Log.e(TAG, "Error setting super properties: " + e.getMessage());
		}
	}

	private static void doProperties(Context context, String key, Object value) {
		if (TextUtils.isEmpty(key)) {
			return;
		}
		if (null == value) {
			return;
		}
		if (value instanceof Integer) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (Integer) value);
		}
		if (value instanceof Float) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (Float) value);
		}
		if (value instanceof Long) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (Long) value);
		}
		if (value instanceof Double) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (Double) value);
		}
		if (value instanceof Boolean) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (Boolean) value);
		}
		if (value instanceof String) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (String) value);
		}
		if (value instanceof JSONArray) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (JSONArray) value);
		}
		if (value instanceof JSONObject) {
			SolarEngineManager.getInstance().setSuperProperties(context, key, (JSONObject) value);
		}
	}

	public static void unsetSuperProperties(String key) {
		try {
			SolarEngineManager.getInstance().unsetSuperProperty(Cocos2dxActivity.getContext(),key);
		} catch (Exception e) {
			Log.e(TAG, "Error unsetting super properties: " + e.getMessage());
		}
	}

	public static void clearSuperProperties() {
		SolarEngineManager.getInstance().clearSuperProperties(Cocos2dxActivity.getContext());
	}

	public static void userDelete(String userDeleteType) {
		try {
			if (userDeleteType.equals("byAccountId")) {
				SolarEngineManager.getInstance().userDelete(SEUserDeleteType.DELETE_BY_ACCOUNTID);
			} else if (userDeleteType.equals("byVisitorId")) {
				SolarEngineManager.getInstance().userDelete(SEUserDeleteType.DELETE_BY_VISITORID);
			} else {
				Log.e(TAG, "userDelete Error userDeleteType fail: " + userDeleteType);
			}
		} catch (Exception e) {
			Log.e(TAG, "Error in user delete: " + e.toString());
		}
	}

	public static void userInit(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			SolarEngineManager.getInstance().userInit(props);
		} catch (Exception e) {
			Log.e(TAG, "Error user init: " + e.getMessage());
		}
	}

	public static void userUpdate(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			SolarEngineManager.getInstance().userUpdate(props);
		} catch (Exception e) {
			Log.e(TAG, "Error user update: " + e.getMessage());
		}
	}

	public static void userAdd(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			SolarEngineManager.getInstance().userAdd(props);
		} catch (Exception e) {
			Log.e(TAG, "Error user add: " + e.getMessage());
		}
	}

	public static void userUnset(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			if (props.has("keys")) {
				JSONArray keysArray = props.optJSONArray("keys");
				if (keysArray != null) {
					String[] keysStringArray = new String[keysArray.length()];
					for (int i = 0; i < keysArray.length(); i++) {
						keysStringArray[i] = keysArray.optString(i);
					}
					SolarEngineManager.getInstance().userUnset(keysStringArray);
				}
			}
		} catch (Exception e) {
			Log.e(TAG, "Error user unset: " + e.getMessage());
		}
	}

	public static void userAppend(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			SolarEngineManager.getInstance().userAppend(props);
		} catch (Exception e) {
			Log.e(TAG, "Error user append: " + e.getMessage());
		}
	}

	// RemoteConfig API
	public static void setDefaultConfig(String configData) {
		try {
			JSONArray defaultConfigArray = new JSONArray();

			JSONObject jsonObject = configData != null ? new JSONObject(configData) : new JSONObject();
			for (Iterator<String> it = jsonObject.keys(); it.hasNext(); ) {
				String key = it.next();
				Object value = jsonObject.get(key);
				defaultConfigArray.put(value);
			}

			RemoteConfigManager.getInstance().setRemoteDefaultConfig(defaultConfigArray);
			Log.d(TAG, "Successfully set remote default config");
		} catch (Exception e) {
			Log.e(TAG, "Error setting default config: " + e.getMessage());
		}
	}

	public static void setRemoteConfigEventProperties(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			RemoteConfigManager.getInstance().setRemoteConfigEventProperties(props);
			Log.d(TAG, "Successfully set remote config event properties");
		} catch (Exception e) {
			Log.e(TAG, "Error setting remote config event properties: " + e.getMessage());
		}
	}

	public static void setRemoteConfigUserProperties(String properties) {
		try {
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			RemoteConfigManager.getInstance().setRemoteConfigUserProperties(props);
			Log.d(TAG, "Successfully set remote config user properties");
		} catch (Exception e) {
			Log.e(TAG, "Error setting remote config user properties: " + e.getMessage());
		}
	}

	public static String fastFetchRemoteConfig(String key) {
		try {
			Object result = RemoteConfigManager.getInstance().fastFetchRemoteConfig(key);
			if (result != null) {
				if (result instanceof String) {
					return (String) result;
				} else {
					return result.toString();
				}
			}
			return "";
		} catch (Exception e) {
			Log.e(TAG, "Error fast fetching remote config: " + e.getMessage());
			return "";
		}
	}

	public static String fastFetchAllRemoteConfig() {
		try {
			Object allConfig = RemoteConfigManager.getInstance().fastFetchRemoteConfig();
			if (allConfig != null) {
				if (allConfig instanceof JSONObject) {
					return ((JSONObject) allConfig).toString();
				} else {
					return allConfig.toString();
				}
			}
			return "{}";
		} catch (Exception e) {
			Log.e(TAG, "Error fast fetching all remote config: " + e.getMessage());
			return "{}";
		}
	}

	public static void asyncFetchRemoteConfig(String key) {
		try {
			RemoteConfigManager.getInstance().asyncFetchRemoteConfig(key, new OnRemoteConfigReceivedData() {
				@Override
				public void onResult(Object o) {
					Log.d(TAG, "asyncFetchRemoteConfig received data: " + o);
					if (!TextUtils.isEmpty(remoteConfigCallbackName)) {
						try {
							String result = o != null ? o.toString() : "";
							Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(remoteConfigCallbackName, result);
							Log.d(TAG, "Successfully called remote config callback: " + remoteConfigCallbackName);
						} catch (Exception e) {
							Log.e(TAG, "Failed to call remote config callback: " + e.getMessage());
						}
					}
				}
			});
		} catch (Exception e) {
			Log.e(TAG, "Error async fetching remote config: " + e.getMessage());
		}
	}

	public static void asyncFetchAllRemoteConfig() {
		try {

			RemoteConfigManager.getInstance().asyncFetchRemoteConfig(new OnRemoteConfigReceivedGenericsData<JSONObject>() {
				@Override
				public void onResult(JSONObject jsonObject) {
					Log.d(TAG, "asyncFetchAllRemoteConfig received data: " + jsonObject);
					if (!TextUtils.isEmpty(remoteConfigAllCallbackName)) {
						try {
							String result = jsonObject != null ? jsonObject.toString() : "{}";
							Cocos2dxLuaJavaBridge.callLuaGlobalFunctionWithString(remoteConfigAllCallbackName, result);
							Log.d(TAG, "Successfully called remote config all callback: " + remoteConfigAllCallbackName);
						} catch (Exception e) {
							Log.e(TAG, "Failed to call remote config all callback: " + e.getMessage());
						}
					}
				}
			});
		} catch (Exception e) {
			Log.e(TAG, "Error async fetching all remote config: " + e.getMessage());
		}
	}

	// 隐私相关 API
	public static void setGDPRArea(String isGDPRArea) {
		try {
			boolean isGDPR = Boolean.parseBoolean(isGDPRArea);
			SolarEngineManager.getInstance().setGDPRArea(isGDPR);
		} catch (Exception e) {
			Log.e(TAG, "Error setting GDPR area: " + e.getMessage());
		}
	}

	public static void setGaid(String gaid) {
		try {
			SolarEngineManager.getInstance().setGaid(gaid);
		} catch (Exception e) {
			Log.e(TAG, "Error setGaid: " + e.getMessage());
		}
	}

	public static void setChannel(String channel) {
		try {
			SolarEngineManager.getInstance().setChannel(channel);
		} catch (Exception e) {
			Log.e(TAG, "Error setChannel: " + e.getMessage());
		}
	}

	// 预置事件属性
	public static void setPresetEvent(String presetEventType, String properties) {
		try {
			int eventType = Integer.parseInt(presetEventType);
			JSONObject props = properties != null ? new JSONObject(properties) : new JSONObject();
			if (properties != null) {
				switch (eventType) {
					case 0:
						SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.AppInstall, props);
						break;
					case 1:
						SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.AppStart, props);
						break;
					case 2:
						SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.AppEnd, props);
						break;
					case 3:
						SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.All, props);
						break;
					default:
						Log.e(TAG, "setPresetEvent failed, eventType is not support! eventType:" + eventType);
						break;
				}
			} else {
				Log.e(TAG, "setPresetEvent failed, properties is null!");
			}
		} catch (Exception e) {
			Log.e(TAG, "Error setting preset event: " + e.getMessage());
		}
	}

	public static String getAttributionData() {
		try {
			JSONObject attributionData = SolarEngineManager.getInstance().getAttribution();
			return attributionData != null ? attributionData.toString() : "{}";
		} catch (Exception e) {
			Log.e(TAG, "Error getting attribution data: " + e.getMessage());
			return "{}";
		}
	}

	private static JSONObject stringToJSONObject (String str) {
		if (str != null && !str.isEmpty()) {
			try {
				return new JSONObject(str);
			}
			catch (JSONException e) {
				e.printStackTrace();
				return new JSONObject();
			}
		}
		else  {
			return new JSONObject();
		}
	}
}