//
//  SolarEngineProxy.h
//  demo iOS
//
//  Created by baixin on 2025/9/19.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface SolarEngineProxy : NSObject

// 初始化和配置
+ (void)preInit:(NSDictionary *)params;
+ (void)initWithConfig:(NSDictionary *)seDict;

+ (void)setInitCallback:(NSDictionary *)params;
+ (void)setDeeplinkCallback:(NSDictionary *)params;
+ (void)setDeferredDeeplinkCallback:(NSDictionary *)params;
+ (void)setAttributionCallback:(NSDictionary *)params;

// 事件追踪
+ (void)track:(NSDictionary *)params;
+ (void)trackIAP:(NSDictionary *)params;
+ (void)trackAdImpression:(NSDictionary *)params;
+ (void)trackAdClick:(NSDictionary *)params;
+ (void)trackAppAttr:(NSDictionary *)params;
+ (void)trackRegister:(NSDictionary *)params;
+ (void)trackLogin:(NSDictionary *)params;
+ (void)trackOrder:(NSDictionary *)params;
+ (void)trackFirstEvent:(NSDictionary *)params;
+ (void)eventStart:(NSDictionary *)params;
+ (void)eventFinish:(NSDictionary *)params;
+ (void)reportEventImmediately:(NSDictionary *)params;

// 用户管理
+ (void)loginWithAccountID:(NSDictionary *)params;
+ (void)logout:(NSDictionary *)params;
+ (NSDictionary *)getAccountID:(NSDictionary *)params;
+ (NSDictionary *)getDistinctId:(NSDictionary *)params;

// 访客 ID
+ (void)setVisitorID:(NSDictionary *)params;
+ (NSDictionary *)getVisitorID:(NSDictionary *)params;

// 属性管理
+ (void)setSuperProperties:(NSDictionary *)params;
+ (void)unsetSuperProperty:(NSDictionary *)params;
+ (void)clearSuperProperties:(NSDictionary *)params;
+ (NSDictionary *)getPresetProperties:(NSDictionary *)params;
+ (void)setPresetEvent:(NSDictionary *)params;

// 用户属性
+ (void)userInit:(NSDictionary *)params;
+ (void)userUpdate:(NSDictionary *)params;
+ (void)userAdd:(NSDictionary *)params;
+ (void)userUnset:(NSDictionary *)params;
+ (void)userAppend:(NSDictionary *)params;
+ (void)userDelete:(NSDictionary *)params;

+ (void)setGDPRArea:(NSDictionary *)params;
+ (NSDictionary *)getAttributionData:(NSDictionary *)params;
+ (void)requestTrackingAuthorization:(NSDictionary *)params;
+ (void)trackAppReEngagement:(NSDictionary *)params;

// SKAN
+ (void)updatePostbackConversionValue:(NSDictionary *)params;
+ (void)updatePostbackConversionValueWithCoarse:(NSDictionary *)params;
+ (void)updatePostbackConversionValueWithCoarseAndLock:(NSDictionary *)params;

// RemoteConfig
+ (void)setDefaultConfig:(NSDictionary *)params;
+ (void)setRemoteConfigEventProperties:(NSDictionary *)params;
+ (void)setRemoteConfigUserProperties:(NSDictionary *)params;
+ (NSDictionary *)fastFetchRemoteConfig:(NSDictionary *)params;
+ (NSDictionary *)fastFetchAllRemoteConfig:(NSDictionary *)params;
+ (void)asyncFetchRemoteConfig:(NSDictionary *)params;
+ (void)asyncFetchAllRemoteConfig:(NSDictionary *)params;

@end

NS_ASSUME_NONNULL_END
