package com.solar.engine;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.reyun.remote.config.OnRemoteConfigReceivedGenericsData;
import com.reyun.remote.config.RemoteConfigManager;
import com.reyun.solar.engine.DeepLinkCallBack;
import com.reyun.solar.engine.DeferredDeepLinkCallback;
import com.reyun.solar.engine.OnAttributionListener;
import com.reyun.solar.engine.SolarEngineManager;
import com.reyun.solar.engine.SolarEngineConfig;
import com.reyun.solar.engine.OnInitializationCallback;
import com.reyun.solar.engine.config.CustomDomain;
import com.reyun.solar.engine.config.RemoteConfig;
import com.reyun.solar.engine.infos.DeeplinkInfo;
import com.reyun.solar.engine.infos.PresetEventType;
import com.reyun.solar.engine.infos.SEAdClickEventModel;
import com.reyun.solar.engine.infos.SEAdImpEventModel;
import com.reyun.solar.engine.infos.SEAppReEngagementModel;
import com.reyun.solar.engine.infos.SEAppRegisterFirstEventModel;
import com.reyun.solar.engine.infos.SEAttrEventModel;
import com.reyun.solar.engine.infos.SECustomEventModel;
import com.reyun.solar.engine.infos.SECustomFirstEventModel;
import com.reyun.solar.engine.infos.SELoginEventModel;
import com.reyun.solar.engine.infos.SEOrderEventModel;
import com.reyun.solar.engine.infos.SEPurchaseEventModel;
import com.reyun.solar.engine.infos.SERegisterEventModel;
import com.reyun.solar.engine.tracker.SEUserDeleteType;
import com.reyun.solar.engine.SeSdkSource;

import android.app.Activity;
import android.os.Build;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import android.annotation.TargetApi;

public class SolarEngineCocosAPI {
    private static final String TAG = "SE.Cocos";

    private static Context appContext;

    public static void preInit(Context context, String appKey) {
        Log.e(TAG,"preInit called");
        SolarEngineManager.getInstance().preInit(context,appKey);
    }

    public static void init(Context context, String appKey, String options) {
        SolarEngineConfig.Builder builder = new SolarEngineConfig.Builder();

        if (context != null) {
            SolarEngineCocosAPI.appContext = context.getApplicationContext();
        }

        try {
            JSONObject configObj = null;
            if (options != null) {
                configObj = new JSONObject(options);
            } else {
                configObj = new JSONObject();
            }
            // 基础配置
            if (configObj.has("enableLog")) {
                boolean enableLog = configObj.optBoolean("enableLog");
                if (enableLog) {
                    builder.logEnabled();
                }
            }

            if (configObj.has("isDebugModel")) {
                boolean isDebugModel = configObj.optBoolean("isDebugModel");
                builder.isDebugModel(isDebugModel);
            }

            if (configObj.has("isGDPRArea")) {
                boolean isGDPRArea = configObj.optBoolean("isGDPRArea");
                builder.isGDPRArea(isGDPRArea);
            }

            if (configObj.has("setCoppaEnabled")) {
                boolean setCoppaEnabled = configObj.optBoolean("setCoppaEnabled");
                builder.setCoppaEnabled(setCoppaEnabled);
            }

            if (configObj.has("setKidsAppEnabled")) {
                boolean setKidsAppEnabled = configObj.optBoolean("setKidsAppEnabled");
                builder.setKidsAppEnabled(setKidsAppEnabled);
            }

            if (configObj.has("enable2GReporting")) {
                boolean enable2GReporting = configObj.optBoolean("enable2GReporting");
                builder.enable2GReporting(enable2GReporting);
            }

            if (configObj.has("enableDeferredDeeplink")) {
                boolean enableDeferredDeeplink = configObj.optBoolean("enableDeferredDeeplink");
                builder.enableDelayDeeplink(enableDeferredDeeplink);
            }

            if (configObj.has("adPersonalizationEnabled")) {
                boolean adPersonalizationEnabled = configObj.optBoolean("adPersonalizationEnabled");
                builder.adPersonalizationEnabled(adPersonalizationEnabled);
            }

            if (configObj.has("adUserDataEnabled")) {
                boolean adUserDataEnabled = configObj.optBoolean("adUserDataEnabled");
                builder.adUserDataEnabled(adUserDataEnabled);
            }

            if (configObj.has("fbAppID")) {
                String fbAppID = configObj.optString("fbAppID");
                if (!TextUtils.isEmpty(fbAppID)) {
                    builder.setFbAppID(fbAppID);
                }
            }
            if (configObj.has("supportMultiProcess")) {
                boolean result = configObj.optBoolean("supportMultiProcess");
                builder.supportMultiProcess(result);
            }
            if (configObj.has("isOAIDEnabled")) {
                boolean result = configObj.optBoolean("isOAIDEnabled");
                builder.isOAIDEnabled(result);
            }
            if (configObj.has("isImeiEnabled")) {
                boolean result = configObj.optBoolean("isImeiEnabled");
                builder.isImeiEnabled(result);
            }
            if (configObj.has("isAndroidIDEnabled")) {
                boolean result = configObj.optBoolean("isAndroidIDEnabled");
                builder.isAndroidIDEnabled(result);
            }
            if (configObj.has("enableIPV6Address")) {
                boolean result = configObj.optBoolean("enableIPV6Address");
                builder.enableIPV6Address(result);
            }

            String subLibVersion = "";
            if (configObj.has("sub_lib_version")) {
                subLibVersion = (String) configObj.optString("sub_lib_version");
            }
            SeSdkSource seSdkSource = new SeSdkSource();
            seSdkSource.setSubLibVersion(subLibVersion);
            seSdkSource.setSdkType("cocos2d-x");
            SolarEngineManager.getInstance().setSeSdkSource(seSdkSource);

            if (configObj.has("remoteConfig")) {
                JSONObject remoteConfigJson = configObj.optJSONObject("remoteConfig");
                if (remoteConfigJson != null) {
                    RemoteConfig remoteConfig = new RemoteConfig();
                    if (remoteConfigJson.has("enable")) {
                        boolean enable = remoteConfigJson.optBoolean("enable");
                        remoteConfig.setEnable(enable);
                    }
                    if (remoteConfigJson.has("mergeType")) {
                        int mergeType = remoteConfigJson.optInt("mergeType");
                        if (mergeType == 1) {
                            remoteConfig.setMergeType(RemoteConfig.MergeType.WITH_USER);
                        } else {
                            remoteConfig.setMergeType(RemoteConfig.MergeType.WITH_CACHE);
                        }
                    }
                    if (remoteConfigJson.has("customIDProperties")) {
                        JSONObject customIDProperties = remoteConfigJson.optJSONObject("customIDProperties");
                        if (customIDProperties != null) {
                            remoteConfig.setCustomIDProperties(customIDProperties);
                        }
                    }
                    if (remoteConfigJson.has("customIDEventProperties")) {
                        JSONObject customIDEventProperties = remoteConfigJson.optJSONObject("customIDEventProperties");
                        if (customIDEventProperties != null) {
                            remoteConfig.setCustomIDEventProperties(customIDEventProperties);
                        }
                    }
                    if (remoteConfigJson.has("customIDUserProperties")) {
                        JSONObject customIDUserProperties = remoteConfigJson.optJSONObject("customIDUserProperties");
                        if (customIDUserProperties != null) {
                            remoteConfig.setCustomIDUserProperties(customIDUserProperties);
                        }
                    }
                    builder.withRemoteConfig(remoteConfig);
                }
            }

            boolean enableCustomDomain = false;
            if (configObj.has("customDomain")) {
                JSONObject customDomainJson = configObj.optJSONObject("customDomain");
                if (customDomainJson != null) {
                    CustomDomain customDomain = new CustomDomain();
                    if (customDomainJson.has("enable")) {
                        enableCustomDomain = customDomainJson.optBoolean("enable");
                    }
                }
            }

            if (configObj.has("customDomain") && enableCustomDomain) {
                Log.e(TAG,configObj.toString());
                JSONObject customDomainJson = configObj.optJSONObject("customDomain");
                if (customDomainJson != null) {
                    CustomDomain customDomain = new CustomDomain();
                    if (customDomainJson.has("enable")) {
                        boolean enable = customDomainJson.optBoolean("enable");
                        customDomain.setEnable(enable);
                    }
                    if (customDomainJson.has("receiverDomain")) {
                        String receiverDomain = customDomainJson.optString("receiverDomain");
                        customDomain.setReceiverDomain(receiverDomain);
                    }
                    if (customDomainJson.has("ruleDomain")) {
                        String ruleDomain = customDomainJson.optString("ruleDomain");
                        customDomain.setRuleDomain(ruleDomain);
                    }
                    if (customDomainJson.has("receiverTcpHost")) {
                        String tcpReceiverHost = customDomainJson.optString("receiverTcpHost");
                        customDomain.setTcpReceiverHost(tcpReceiverHost);
                    }
                    if (customDomainJson.has("ruleTcpHost")) {
                        String tcpRuleHost = customDomainJson.optString("ruleTcpHost");
                        customDomain.setTcpRuleHost(tcpRuleHost);
                    }
                    if (customDomainJson.has("gatewayTcpHost")) {
                        String tcpGatewayHost = customDomainJson.optString("gatewayTcpHost");
                        customDomain.setTcpGatewayHost(tcpGatewayHost);
                    }
                    builder.withCustomDomain(customDomain);
                }
            }

        } catch (Exception e) {
            Log.e(TAG, "Error parsing config: " + e.getMessage());
        }

        SolarEngineConfig config = builder.build();

        config.setOnAttributionListener(new OnAttributionListener() {
            @Override
            public void onAttributionSuccess(JSONObject jsonObject) {
                JSONObject attrResult = new JSONObject();
                try {
                    if (jsonObject != null) {
                        attrResult.put("code", 0);
                        attrResult.put("data", jsonObject);
                    } else {
                        attrResult.put("code", -1);
                    }
                } catch (JSONException e) {
                    Log.e(TAG,"onAttributionFail JSONException : "+e);
                }
                nativeOnAttributionCompleted(attrResult);
            }

            @Override
            public void onAttributionFail(int i) {
                JSONObject attrResult = new JSONObject();
                try {
                    attrResult.put("code", i);
                } catch (JSONException e) {
                    Log.e(TAG,"onAttributionFail JSONException : "+e);
                }
                nativeOnAttributionCompleted(attrResult);
            }
        });

        SolarEngineManager.getInstance().setDeferredDeepLinkCallback(new DeferredDeepLinkCallback() {
            @Override
            public void onReceivedSuccess(JSONObject jsonObject) {
                JSONObject attrResult = new JSONObject();
                try {
                    if (jsonObject != null) {
                        attrResult.put("code", 0);
                        attrResult.put("data", jsonObject);
                    } else {
                        attrResult.put("code", -1);
                    }
                } catch (JSONException e) {
                    Log.e(TAG,"onAttributionFail JSONException : "+e);
                }
                nativeOnDeferredDeeplinkCompleted(attrResult);
            }

            @Override
            public void onReceivedFailed(int i) {
                JSONObject attrResult = new JSONObject();
                try {
                    attrResult.put("code", i);
                } catch (JSONException e) {
                    Log.e(TAG,"onAttributionFail JSONException : "+e);
                }
                nativeOnDeferredDeeplinkCompleted(attrResult);
            }
        });

        SolarEngineManager.getInstance().setDeepLinkCallback(new DeepLinkCallBack() {
            @Override
            public void onReceived(int i, DeeplinkInfo deeplinkInfo) {

                JSONObject callBackResult = new JSONObject();
                JSONObject data = new JSONObject();
                try {
                    if (deeplinkInfo != null) {
                        data.put("sedpLink", deeplinkInfo.sedpLink);
                        data.put("turlId", deeplinkInfo.turlId);
                        data.put("from", deeplinkInfo.from);
                        data.put("baseUrl", deeplinkInfo.baseURL);
                        data.put("url", deeplinkInfo.url);
                        data.put("customParams", deeplinkInfo.customParams);
                    }
                } catch (JSONException e) {
                    Log.e(TAG,"onReceived JSONException : "+e);
                }

                try {
                    callBackResult.put("code", i);
                    callBackResult.put("data", data);
                } catch (JSONException e) {
                    Log.e(TAG,"onReceived JSONException : "+e);
                }
                nativeOnDeeplinkCompleted(callBackResult);
            }
        });

        Log.e(TAG,"initialize called.");
        SolarEngineManager.getInstance().initialize(context, appKey, config, new OnInitializationCallback() {
            @Override
            public void onInitializationCompleted(int i) {
                Log.e(TAG,"onInitializationCompleted = "+i);
                // 通过 JNI 回调到 C++ 代码
                nativeOnInitCompleted(i);
            }
        });
    }

    // ========= Remote Config bridge =========
    public static void setRemoteDefaultConfig(String jsonArrayString) {
        try {
            if (TextUtils.isEmpty(jsonArrayString)) return;
            JSONArray arr = new JSONArray(jsonArrayString);
            RemoteConfigManager.getInstance().setRemoteDefaultConfig(arr);
        } catch (Throwable t) {
            Log.e(TAG, "setRemoteDefaultConfig error: "+t);
        }
    }

    public static void setRemoteConfigEventProperties(String jsonString) {
        try {
            if (TextUtils.isEmpty(jsonString)) return;
            JSONObject obj = new JSONObject(jsonString);
            RemoteConfigManager.getInstance().setRemoteConfigEventProperties(obj);
        } catch (Throwable t) {
            Log.e(TAG, "setRemoteConfigEventProperties error: "+t);
        }
    }

    public static void setRemoteConfigUserProperties(String jsonString) {
        try {
            if (TextUtils.isEmpty(jsonString)) return;
            JSONObject obj = new JSONObject(jsonString);
            RemoteConfigManager.getInstance().setRemoteConfigUserProperties(obj);
        } catch (Throwable t) {
            Log.e(TAG, "setRemoteConfigUserProperties error: "+t);
        }
    }

    // 同步获取单个参数，包一层，返回 {"type":1/2/3/4, "value": <string|number|boolean|json>}
    public static String fastFetchRemoteConfigWrap(String paramKey) {
        try {
            Object result = RemoteConfigManager.getInstance().fastFetchRemoteConfig(paramKey);
            if (result == null) return "";
            if (result instanceof String) {
                return (String)result;
            } else if (result instanceof Integer || result instanceof Long) {
                return String.valueOf(result);
            } else if (result instanceof Boolean) {
                return String.valueOf(result);
            } else if (result instanceof JSONObject || result instanceof JSONArray) {
                return result.toString();
            } else {
                return String.valueOf(result);
            }
        } catch (Throwable t) {
            Log.e(TAG, "fastFetchRemoteConfigWrap error: "+t);
        }
        return "";
    }

    // 异步获取单个参数，回调到 C++
    public static void asyncFetchRemoteConfig(final String paramKey) {
        try {
            RemoteConfigManager.getInstance().asyncFetchRemoteConfig(paramKey, data -> {
                try {
                    String value = "";
                    if (data instanceof String) {
                        value = (String)data;
                    } else if (data instanceof Integer || data instanceof Long) {
                        value = String.valueOf(data);
                    } else if (data instanceof Boolean) {
                        value = String.valueOf(data);
                    } else if (data instanceof JSONObject || data instanceof JSONArray) {
                        value = data.toString();
                    } else {
                        value = String.valueOf(data);
                    }
                    nativeOnRemoteConfigResult(value);
                } catch (Throwable t) {
                    Log.e(TAG, "asyncFetchRemoteConfig callback error: "+t);
                }
            });
        } catch (Throwable t) {
            Log.e(TAG, "asyncFetchRemoteConfig error: "+t);
        }
    }

    // 同步获取全部参数：返回 JSONObject（包含默认+缓存）
    public static JSONObject fastFetchAllRemoteConfigWrap() {
        try {
            JSONObject all = RemoteConfigManager.getInstance().fastFetchRemoteConfig();
            return all != null ? all : new JSONObject();
        } catch (Throwable t) {
            Log.e(TAG, "fastFetchAllRemoteConfigWrap error: "+t);
            return new JSONObject();
        }
    }

    // 异步获取全部参数：回调到 C++
    public static void asyncFetchAllRemoteConfig() {
        RemoteConfigManager.getInstance().asyncFetchRemoteConfig(new OnRemoteConfigReceivedGenericsData<JSONObject>() {
            @Override
            public void onResult(JSONObject jsonObject) {
                try {
                    JSONObject out = jsonObject != null ? jsonObject : new JSONObject();
                    nativeOnRemoteConfigAllResult(out);
                } catch (Throwable t) {
                    Log.e(TAG, "asyncFetchAllRemoteConfig callback error: " + t);
                }
            }
        });

    }

    // 原生到 C++ 的远程配置回调（单个key）
    private static native void nativeOnRemoteConfigResult(String result);
    // 原生到 C++ 的远程配置回调（全部）
    private static native void nativeOnRemoteConfigAllResult(JSONObject result);

    // 声明 JNI 回调方法
    private static native void nativeOnInitCompleted(int resultCode);
    private static native void nativeOnAttributionCompleted(JSONObject result);
    private static native void nativeOnDeferredDeeplinkCompleted(JSONObject result);
    private static native void nativeOnDeeplinkCompleted(JSONObject result);

    public static void setGDPRArea(boolean isGDPRArea) {
        SolarEngineManager.getInstance().setGDPRArea(isGDPRArea);
    }


    // 事件追踪方法
    public static void trackCustomEvent(String eventName, JSONObject customProperties, JSONObject presetProperties) {
        try {
            SECustomEventModel seCustomEventModel = new SECustomEventModel();
            if (customProperties != null) {
                seCustomEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(eventName)) {
                seCustomEventModel.setCustomEventName(eventName);
            }
            if (presetProperties != null) {
                seCustomEventModel.setPreEventData(presetProperties);
            }
            SolarEngineManager.getInstance().track(seCustomEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking custom event: " + e.getMessage());
        }
    }

    public static void trackRegisterEvent(String registerType, String registerStatus, JSONObject customProperties) {
        try {
            SERegisterEventModel seRegisterEventModel = new SERegisterEventModel();
            if (customProperties != null) {
                seRegisterEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(registerType)) {
                seRegisterEventModel.setRegType(registerType);
            }
            if (!TextUtils.isEmpty(registerStatus)) {
                seRegisterEventModel.setStatus(registerStatus);
            }
            SolarEngineManager.getInstance().trackAppRegister(seRegisterEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking register event: " + e.getMessage());
        }
    }

    public static void trackIAPEvent(String productID,
                                     String productName,
                                        int productCount,
                                     double payAmount,
                                     String orderId,
                                     String currencyType,
                                     String payType,
                                        int payStatus,
                                     String failReason,
                                    JSONObject customProperties) {
        try {
            SEPurchaseEventModel sePurchaseEventModel = new SEPurchaseEventModel();
            if (customProperties != null) {
                sePurchaseEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(orderId)) {
                sePurchaseEventModel.setOrderId(orderId);
            }
            sePurchaseEventModel.setPayAmount(payAmount);
            if (!TextUtils.isEmpty(currencyType)) {
                sePurchaseEventModel.setCurrencyType(currencyType);
            }
            if (!TextUtils.isEmpty(payType)) {
                sePurchaseEventModel.setPayType(payType);
            }
            if (!TextUtils.isEmpty(productID)) {
                sePurchaseEventModel.setProductId(productID);
            }
            if (!TextUtils.isEmpty(productName)) {
                sePurchaseEventModel.setProductName(productName);
            }
            sePurchaseEventModel.setProductNum(productCount);
            sePurchaseEventModel.setPayStatus(payStatus);
            if (!TextUtils.isEmpty(failReason)) {
                sePurchaseEventModel.setFailReason(failReason);
            }
            SolarEngineManager.getInstance().trackPurchase(sePurchaseEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking IAP event: " + e.getMessage());
        }
    }

    public static void trackAdImpressionEvent(int adType, String adNetworkPlatform, 
                                            String adNetworkAppID, String adNetworkPlacementID, 
                                            String currency, double ecpm, String mediationPlatform, 
                                            boolean rendered, JSONObject customProperties) {
        try {
            SEAdImpEventModel seAdImpEventModel = new SEAdImpEventModel();
            if (customProperties != null) {
                seAdImpEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(adNetworkPlatform)) {
                seAdImpEventModel.setAdNetworkPlatform(adNetworkPlatform);
            }
            seAdImpEventModel.setAdType(adType);
            if (!TextUtils.isEmpty(adNetworkAppID)) {
                seAdImpEventModel.setAdNetworkAppID(adNetworkAppID);
            }
            if (!TextUtils.isEmpty(adNetworkPlacementID)) {
                seAdImpEventModel.setAdNetworkADID(adNetworkPlacementID);
            }
            if (!TextUtils.isEmpty(mediationPlatform)) {
                seAdImpEventModel.setMediationPlatform(mediationPlatform);
            }
            seAdImpEventModel.setEcpm(ecpm);
            if (!TextUtils.isEmpty(currency)) {
                seAdImpEventModel.setCurrencyType(currency);
            }
            seAdImpEventModel.setRenderSuccess(rendered);
            SolarEngineManager.getInstance().trackAdImpression(seAdImpEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking ad impression event: " + e.getMessage());
        }
    }

    public static void trackAdClickEvent(int adType, String adNetworkPlatform, 
                                       String adNetworkPlacementID, String mediationPlatform, 
                                       String adNetworkAppID, JSONObject customProperties) {
        try {
            SEAdClickEventModel seAdClickEventModel = new SEAdClickEventModel();
            if (customProperties != null) {
                seAdClickEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(adNetworkPlatform)) {
                seAdClickEventModel.setAdPlatform(adNetworkPlatform);
            }
            seAdClickEventModel.setAdType(adType);
            if (!TextUtils.isEmpty(adNetworkPlacementID)) {
                seAdClickEventModel.setAdNetworkADID(adNetworkPlacementID);
            }
            if (!TextUtils.isEmpty(mediationPlatform)) {
                seAdClickEventModel.setMediationPlatform(mediationPlatform);
            }
            SolarEngineManager.getInstance().trackAdClick(seAdClickEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking ad click event: " + e.getMessage());
        }
    }

    public static void trackAppAttrEvent(String adNetwork, String subChannel, String adAccountID, 
                                       String adAccountName, String adCampaignID, String adCampaignName, 
                                       String adOfferID, String adOfferName, String adCreativeID, 
                                       String adCreativeName, String attributionPlatform, 
                                       JSONObject customProperties) {
        try {
            SEAttrEventModel seAttrEventModel = new SEAttrEventModel();
            if (customProperties != null) {
                seAttrEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(adNetwork)) {
                seAttrEventModel.setAdNetwork(adNetwork);
            }
            if (!TextUtils.isEmpty(subChannel)) {
                seAttrEventModel.setSubChannel(subChannel);
            }
            if (!TextUtils.isEmpty(adAccountID)) {
                seAttrEventModel.setAdAccountId(adAccountID);
            }
            if (!TextUtils.isEmpty(adAccountName)) {
                seAttrEventModel.setAdAccountName(adAccountName);
            }
            if (!TextUtils.isEmpty(adCampaignID)) {
                seAttrEventModel.setAdCampaignId(adCampaignID);
            }
            if (!TextUtils.isEmpty(adCampaignName)) {
                seAttrEventModel.setAdCampaignName(adCampaignName);
            }
            if (!TextUtils.isEmpty(adOfferID)) {
                seAttrEventModel.setAdOfferId(adOfferID);
            }
            if (!TextUtils.isEmpty(adOfferName)) {
                seAttrEventModel.setAdOfferName(adOfferName);
            }
            if (!TextUtils.isEmpty(adCreativeID)) {
                seAttrEventModel.setAdCreativeId(adCreativeID);
            }
            if (!TextUtils.isEmpty(adCreativeName)) {
                seAttrEventModel.setAdCreativeName(adCreativeName);
            }
            if (!TextUtils.isEmpty(attributionPlatform)) {
                seAttrEventModel.setAttributionPlatform(attributionPlatform);
            }
            SolarEngineManager.getInstance().trackAttr(seAttrEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking app attr event: " + e.getMessage());
        }
    }

    public static void trackLoginEvent(String loginType, String loginStatus, JSONObject customProperties) {
        try {
            SELoginEventModel seLoginEventModel = new SELoginEventModel();
            if (customProperties != null) {
                seLoginEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(loginType)) {
                seLoginEventModel.setLoginType(loginType);
            }
            if (!TextUtils.isEmpty(loginStatus)) {
                seLoginEventModel.setStatus(loginStatus);
            }
            SolarEngineManager.getInstance().trackAppLogin(seLoginEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking login event: " + e.getMessage());
        }
    }

    public static void trackOrderEvent(String orderID, double payAmount, String currencyType, 
                                     String payType, String status, JSONObject customProperties) {
        try {
            SEOrderEventModel seOrderEventModel = new SEOrderEventModel();
            if (customProperties != null) {
                seOrderEventModel.setCustomProperties(customProperties);
            }
            if (!TextUtils.isEmpty(orderID)) {
                seOrderEventModel.setOrderId(orderID);
            }
            seOrderEventModel.setPayAmount(payAmount);
            if (!TextUtils.isEmpty(currencyType)) {
                seOrderEventModel.setCurrencyType(currencyType);
            }
            if (!TextUtils.isEmpty(payType)) {
                seOrderEventModel.setPayType(payType);
            }
            if (!TextUtils.isEmpty(status)) {
                seOrderEventModel.setStatus(status);
            }
            SolarEngineManager.getInstance().trackOrder(seOrderEventModel);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking order event: " + e.getMessage());
        }
    }
    public static void trackFirstEvent( String eventName, String firstCheckId, JSONObject properties) {

        if (TextUtils.isEmpty(eventName)) {
            Log.e(TAG, "trackFirstEvent failed, eventName is empty!");
            return;
        }

        if (eventName.equals("_appReg")) {

            if (properties == null) {
                Log.e(TAG, "trackFirstEvent failed, eventName _appReg , properties is empty!");
                return;
            }

            SEAppRegisterFirstEventModel seRegisterEventModel = new SEAppRegisterFirstEventModel();
            JSONObject customProperties = properties.optJSONObject("customProperties");
            if (customProperties != null) {
                seRegisterEventModel.setCustomProperties(customProperties);
            }
            String registerType = properties.optString("registerType");
            if (!TextUtils.isEmpty(registerType)) {
                seRegisterEventModel.setRegType(registerType);
            }
            String registerStatus = properties.optString("registerStatus");
            if (!TextUtils.isEmpty(registerStatus)) {
                seRegisterEventModel.setStatus(registerStatus);
            }
            if (!TextUtils.isEmpty(firstCheckId)) {
                seRegisterEventModel.setCheckId(firstCheckId);
            }
            SolarEngineManager.getInstance().trackFirstEvent(seRegisterEventModel);

        } else  {

            if(eventName.charAt(0) == '_') {
                Log.e(TAG, "trackFirstEvent Error:" + "trackFirstEvent api only support _appReg event and custom event.");
            }

            SECustomFirstEventModel seCustomEventModel = new SECustomFirstEventModel();
            if (properties != null) {
                seCustomEventModel.setCustomProperties(properties);
            }
            if (!TextUtils.isEmpty(eventName)) {
                seCustomEventModel.setEventName(eventName);
            }
            if (!TextUtils.isEmpty(firstCheckId)) {
                seCustomEventModel.setCheckId(firstCheckId);
            }
        }
    }

    // 事件时长追踪
    public static void eventStart(String eventName) {
        try {
            if (!TextUtils.isEmpty(eventName)) {
                SolarEngineManager.getInstance().eventStart(eventName);
            } else {
                Log.e(TAG, "eventStart failed, eventName is empty!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error starting event: " + e.getMessage());
        }
    }

    public static void eventFinish(String eventName, JSONObject properties) {
        try {
            if (TextUtils.isEmpty(eventName)) {
                Log.e(TAG, "eventFinish failed, eventName is empty!");
                return;
            }
            SolarEngineManager.getInstance().eventFinish(eventName, properties);
        } catch (Exception e) {
            Log.e(TAG, "Error finishing event: " + e.getMessage());
        }
    }

    // 预置事件属性
    public static void setPresetEvent(int eventType, JSONObject properties) {
        try {
            if (properties != null) {
                switch (eventType) {
                    case 0:
                        SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.AppInstall, properties);
                        break;
                    case 1:
                        SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.AppStart, properties);
                        break;
                    case 2:
                        SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.AppEnd, properties);
                        break;
                    case 3:
                        SolarEngineManager.getInstance().setPresetEventProperties(PresetEventType.All, properties);
                        break;
                    default:
                        Log.e(TAG, "setPresetEvent failed, eventType is not support! eventType:" + eventType);
                        break;
                }
            } else {
                Log.e(TAG, "setPresetEvent failed, properties is null!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error setting preset event: " + e.getMessage());
        }
    }

    public static JSONObject getPresetProperties() {
        try {
            return SolarEngineManager.getInstance().getPresetProperties();
        } catch (Exception e) {
            Log.e(TAG, "Error getting preset properties: " + e.getMessage());
            return new JSONObject();
        }
    }

    public static JSONObject getAttributionData() {
        try {
            return SolarEngineManager.getInstance().getAttribution();
        } catch (Exception e) {
            Log.e(TAG, "Error getting attribution data: " + e.getMessage());
            return new JSONObject();
        }
    }

    public static void appDeeplinkOpenURL(String uriString) {
        try {
            if (!TextUtils.isEmpty(uriString)) {
                Uri uri = Uri.parse(uriString);
                SolarEngineManager.getInstance().appDeeplinkOpenURI(uri);
            } else {
                Log.e(TAG, "appDeeplinkOpenURL failed, url is empty!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error opening deeplink: " + e.getMessage());
        }
    }

    public static void setGaid(String gaid) {
        try {
            if (!TextUtils.isEmpty(gaid)) {
                SolarEngineManager.getInstance().setGaid(gaid);
            } else {
                Log.e(TAG, "setGaid failed, gaid is empty!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error setting setGaid : " + e.getMessage());
        }
    }
    public static void setChannel(String channel) {
        try {
            if (!TextUtils.isEmpty(channel)) {
                SolarEngineManager.getInstance().setChannel(channel);
            } else {
                Log.e(TAG, "setChannel failed, channel is empty!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error setting channel : " + e.getMessage());
        }
    }

    public static void setVisitorID(String visitorId) {
        try {
            if (!TextUtils.isEmpty(visitorId)) {
                SolarEngineManager.getInstance().setVisitorID(visitorId);
            } else {
                Log.e(TAG, "setVisitorID failed, visitorId is empty!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error setting visitor ID: " + e.getMessage());
        }
    }

    public static String getVisitorID() {
        try {
            return SolarEngineManager.getInstance().getVisitorID();
        } catch (Exception e) {
            Log.e(TAG, "Error getting visitor ID: " + e.getMessage());
            return "";
        }
    }

    public static void reportEventImmediately() {
        try {
            SolarEngineManager.getInstance().reportEventImmediately();
        } catch (Exception e) {
            Log.e(TAG, "Error reporting event immediately: " + e.getMessage());
        }
    }

    public static void loginWithAccountID(String accountId) {
        try {
            if (!TextUtils.isEmpty(accountId)) {
                SolarEngineManager.getInstance().login(accountId);
            } else {
                Log.e(TAG, "loginWithAccountID failed, accountId is empty!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error logging in with account ID: " + e.getMessage());
        }
    }

    public static String getAccountID() {
        try {
            return SolarEngineManager.getInstance().getAccountID();
        } catch (Exception e) {
            Log.e(TAG, "Error getting account ID: " + e.getMessage());
            return "";
        }
    }

    public static void logout() {
        try {
            SolarEngineManager.getInstance().logout();
        } catch (Exception e) {
            Log.e(TAG, "Error logging out: " + e.getMessage());
        }
    }

    public static String getDistinctId() {
        try {
            return SolarEngineManager.getInstance().getDistinctId();
        } catch (Exception e) {
            Log.e(TAG, "Error getting distinct ID: " + e.getMessage());
            return "";
        }
    }

    public static void setSuperProperties(JSONObject properties) {
        try {
            if (properties != null) {
                Iterator<String> sIterator = properties.keys();
                while (sIterator.hasNext()) {
                    try {
                        String key = sIterator.next();
                        Object value = properties.get(key);
                        doProperties(getCocosContext(), key, value);
                    } catch (JSONException e) {
                        Log.e(TAG, "setSuperProperties JSONException : " + e);
                    }
                }
            } else {
                Log.e(TAG, "setSuperProperties failed, superProperties is null!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error setting super properties: " + e.getMessage());
        }
    }

    private static void doProperties(Context context, String key, Object value) {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        if (null == value) {
            return;
        }
        if (value instanceof Integer) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (Integer) value);
        }
        if (value instanceof Float) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (Float) value);
        }
        if (value instanceof Long) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (Long) value);
        }
        if (value instanceof Double) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (Double) value);
        }
        if (value instanceof Boolean) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (Boolean) value);
        }
        if (value instanceof String) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (String) value);
        }
        if (value instanceof JSONArray) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (JSONArray) value);
        }
        if (value instanceof JSONObject) {
            SolarEngineManager.getInstance().setSuperProperties(context, key, (JSONObject) value);
        }
    }

    public static void unsetSuperProperty(String key) {
        try {
            if (!TextUtils.isEmpty(key)) {
                SolarEngineManager.getInstance().unsetSuperProperty(getCocosContext(), key);
            } else {
                Log.e(TAG, "unsetSuperProperty failed, key is empty!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error unsetting super property: " + e.getMessage());
        }
    }

    public static void clearSuperProperties() {
        try {
            SolarEngineManager.getInstance().clearSuperProperties(getCocosContext());
        } catch (Exception e) {
            Log.e(TAG, "Error clearing super properties: " + e.getMessage());
        }
    }

    public static void userInit(JSONObject properties) {
        try {
            if (properties != null) {
                SolarEngineManager.getInstance().userInit(properties);
            } else {
                Log.e(TAG, "userInit failed, properties is null!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error initializing user: " + e.getMessage());
        }
    }

    public static void userUpdate(JSONObject properties) {
        try {
            if (properties != null) {
                SolarEngineManager.getInstance().userUpdate(properties);
            } else {
                Log.e(TAG, "userUpdate failed, properties is null!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error updating user: " + e.getMessage());
        }
    }

    public static void userAdd(JSONObject properties) {
        try {
            if (properties != null) {
                SolarEngineManager.getInstance().userAdd(properties);
            } else {
                Log.e(TAG, "userAdd failed, properties is null!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error adding user: " + e.getMessage());
        }
    }

    public static void userUnset(String[] keys) {
        try {
            if (keys != null && keys.length > 0) {
                SolarEngineManager.getInstance().userUnset(keys);
            } else {
                Log.e(TAG, "userUnset failed, keys is invalid!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error unsetting user: " + e.getMessage());
        }
    }

    public static void userAppend(JSONObject properties) {
        try {
            if (properties != null) {
                SolarEngineManager.getInstance().userAppend(properties);
            } else {
                Log.e(TAG, "userAppend failed, properties is null!");
            }
        } catch (Exception e) {
            Log.e(TAG, "Error appending user: " + e.getMessage());
        }
    }

    public static void userDelete(int deleteType) {
        try {
            switch (deleteType) {
                case 0: // byAccountId
                    SolarEngineManager.getInstance().userDelete(SEUserDeleteType.DELETE_BY_ACCOUNTID);
                    break;
                case 1: // byVisitorId
                    SolarEngineManager.getInstance().userDelete(SEUserDeleteType.DELETE_BY_VISITORID);
                    break;
                default:
                    Log.e(TAG, "userDelete failed, deleteType is not support! deleteType:" + deleteType);
                    break;
            }
        } catch (Exception e) {
            Log.e(TAG, "Error deleting user: " + e.getMessage());
        }
    }

    public static void trackAppReEngagement(JSONObject customProperties) {
        try {
            SEAppReEngagementModel model = new SEAppReEngagementModel();
            if (customProperties != null) {
                model.setCustomProperties(customProperties);
            }
            SolarEngineManager.getInstance().trackAppReEngagement(model);
        } catch (Exception e) {
            Log.e(TAG, "Error tracking app re-engagement: " + e.getMessage());
        }
    }

    @TargetApi(Build.VERSION_CODES.KITKAT)
    public static Context getCocosContext() {

        if (SolarEngineCocosAPI.appContext != null) {
            return SolarEngineCocosAPI.appContext;
        }

        Class<?> sdkWrapper = null;
        Class<?> cocos2dxActivity = null;
        try {
            sdkWrapper = Class.forName("com.cocos.service.SDKWrapper");
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (sdkWrapper == null) {
            try {
                cocos2dxActivity = Class.forName("org.cocos2dx.lib.Cocos2dxActivity");
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (cocos2dxActivity == null) {
                return null;
            } else {
                try {
                    Method methodGetContext = cocos2dxActivity.getMethod("getContext");
                    return (Context) methodGetContext.invoke(null);
                } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                Method methodShared = sdkWrapper.getMethod("shared");
                Object instance = methodShared.invoke(null);
                if (instance != null) {
                    Method methodGetActivity = sdkWrapper.getMethod("getActivity");
                    return (Activity) methodGetActivity.invoke(instance);
                }
            } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
