#pragma once
#include <stdio.h>
#include <string>
#include <map>
#include <vector>
#include <functional>

using namespace std;

namespace solarengine
{

    class SEJSONObject
    {
    public:
        void setNumber(const char *propertyName, int32_t value);

        void setNumber(const char *propertyName, int64_t value);

        void setNumber(const char *propertyName, double value);

        void setString(const char *propertyName, const char *value);

        void setBool(const char *propertyName, bool value);

        void setList(const char *propertyName, const std::vector<string> &value);

        void setDateTime(const char *propertyName, time_t seconds, int milliseconds);

        void setDateTime(const char *propertyName, const char *value);

        void clear();

        static string toJson(const SEJSONObject &node);

        static SEJSONObject toObject(const char *string);

        void mergeFrom(const SEJSONObject &anotherNode);

        void removeKey(const char *propertyName);

        void setList(const char *propertyName, const std::vector<SEJSONObject> &value);

        void setJsonObject(const char *propertyName, const SEJSONObject &node);

        class ValueNode;

        std::map<string, ValueNode> propertiesMap;

        enum ValueNodeType
        {
            NUMBER,
            INT,
            STRING,
            LIST,
            DATETIME,
            BOOL1,
            OBJECT,
            OBJECTS,
            UNKNOWN,
        };

    private:
        static void dumpNode(const SEJSONObject &node, string *buffer);
    };

    class SEJSONObject::ValueNode
    {
    public:
        ValueNode() : nodeType(UNKNOWN) {}

        explicit ValueNode(double value);

        explicit ValueNode(int64_t value);

        explicit ValueNode(const string &value);

        explicit ValueNode(bool value);

        explicit ValueNode(const SEJSONObject &value);

        explicit ValueNode(const std::vector<SEJSONObject> &value);

        explicit ValueNode(const std::vector<string> &value);

        ValueNode(time_t seconds, int milliseconds);

        static void toStr(const ValueNode &node, string *buffer);

        ValueNodeType getType() const { return nodeType; }

        const SEJSONObject &getObjectData() const { return objectData; }

    private:
        static void dumpString(const string &value, string *buffer);

        static void dumpList(const std::vector<string> &value, string *buffer);

        static void dumpDateTime(const time_t &seconds, int milliseconds, string *buffer);

        static void dumpNumber(double value, string *buffer);

        static void dumpNumber(int64_t value, string *buffer);

        static void dumpList(const std::vector<SEJSONObject> &value, string *buffer);

        static void dumpObject(SEJSONObject value, string *buffer);

        ValueNodeType nodeType;

        union UnionValue
        {
            double numberValue;
            bool boolValue;
            struct
            {
                time_t seconds;
                int milliseconds;
            } datetimeValue;
            int64_t intValue;

            UnionValue() { memset(this, 0, sizeof(UnionValue)); }
        } valueData;

        string stringData;
        std::vector<string> listData;
        std::vector<SEJSONObject> objectDatas;
        SEJSONObject objectData;
    };

    class PresetProperties
    {
    public:
        string bundleId;
        string carrier;
        string deviceId;
        string deviceModel;
        string manufacturer;
        string networkType;
        string os;
        string osVersion;
        int screenHeight;
        int screenWidth;
        string systemLanguage;
        double zoneOffset;
        string appVersion;
        string libName;
        string libVersion;

        SEJSONObject *toEventPresetProperties();
    };
}
