#include <string>
#include <iostream>
#include <sstream>
#include "SEJSONObject.h"

const string SE_COCOS_LIB_VERSION = "1.0.1";

using namespace std;

#if CC_TARGET_PLATFORM == CC_PLATFORM_ANDROID || CC_TARGET_PLATFORM == CC_PLATFORM_IOS

namespace solarengine
{
    struct SECRemoteConfigItem {
        int type;
        string name;
        string value;
    };

    enum SECPresetEventType {
        AppInstall,
        AppStart,
        AppEnd,
        All
    };
    enum SECDeleteType {
        byAccountId,
        byVisitorId,
    };


    struct SECRemoteConfig
    {
        bool enable = false;
        SEJSONObject customIDEventProperties;
        SEJSONObject customIDUserProperties;
        int mergeType; // 0: 默认策略, 1: 用户策略
    };

    struct SECCustomDomain
    {
        bool enable = false;
        string receiverDomain;
        string ruleDomain;
        string receiverTcpHost;
        string ruleTcpHost;
        string gatewayTcpHost;
    };

    struct SECConfig
    {
        bool enableLog = false;
        bool isDebugModel = false;
        bool isGDPRArea = false;
        bool setCoppaEnabled = false;
        bool setKidsAppEnabled = false;
        bool enable2GReporting = false;
        bool enableDeferredDeeplink = false;
        SECRemoteConfig remoteConfig;
        SECCustomDomain customDomain;

        int attAuthorizationWaitingInterval = 0;
        bool enableODMInfo = false;
        string caid;
        
        bool adPersonalizationEnabled = false;
        bool adUserDataEnabled = false;
        string setFbAppID;
        bool supportMultiProcess = false;
        bool isOAIDEnabled = true;
        bool isImeiEnabled = true;
        bool isAndroidIDEnabled = true;
        bool enableIPV6Address = true;        
    };

    struct SEEventBaseAttribute
    {
        string firstCheckId;
    };

    struct SECustomEvent : public SEEventBaseAttribute
    {
        string eventName;
        SEJSONObject customProperties;
        SEJSONObject presetProperties;
    };

    struct SEPurchaseEvent : public SEEventBaseAttribute
    {
        string productId;
        string productName;
        int productNum;
        string orderId;
        double payAmount;
        string currencyType;
        string payType;
        int payStatus;
        string failReason;
        SEJSONObject customProperties;
    };

    struct SEAdImpressionEvent : public SEEventBaseAttribute
    {
        int adType;
        string adNetworkPlatform;
        string adNetworkAppID;
        string adNetworkPlacementID;
        string currency;
        double ecpm;
        string mediationPlatform;
        bool rendered;
        SEJSONObject customProperties;
    };

    struct SEAdClickEvent : public SEEventBaseAttribute
    {
        int adType;
        string adNetworkPlatform;
        string adNetworkPlacementID;
        string mediationPlatform;
        SEJSONObject customProperties;
    };

    struct SEAppAttrEvent : public SEEventBaseAttribute
    {
        string adNetwork;
        string subChannel;
        string adAccountId;
        string adAccountName;
        string adCampaignId;
        string adCampaignName;
        string adOfferId;
        string adOfferName;
        string adCreativeId;
        string adCreativeName;
        string attributionPlatform;
        SEJSONObject customProperties;
    };

    struct SERegisterEvent : public SEEventBaseAttribute
    {
        string registerType;
        string registerStatus;
        SEJSONObject customProperties;
    };

    struct SELoginEvent : public SEEventBaseAttribute
    {
        string loginType;
        string loginStatus;
        SEJSONObject customProperties;
    };

    struct SEOrderEvent : public SEEventBaseAttribute
    {
        string orderId;
        double payAmount;
        string currencyType;
        string payType;
        string status;
        SEJSONObject customProperties;
    };

    struct AttributionData
    {
        // For detailed description, please refer to: https://help.solar-engine.com/en/docs/SDK-Attribution-Result-Details
        int code = -1;
        string account_id;
        string ad_type;
        string adcreative_id;
        string adcreative_name;
        string adcreative_type;
        string adgroup_id;
        string adgroup_name;
        string adplan_id;
        string adplan_name;
        string attribution_time;
        string attribution_touch_type;
        string attribution_type;
        string callback_id;
        string channel_id;
        string channel_name;
        string click_id;
        string conversion_id;
        string impression_id;
        string install_time;
        string placement_id;
        string report_time;
        string request_id;
        string ry_touchpoint_ts;
        string site_id;
        string site_name;
        string turl_campaign_id;
        string turl_campaign_name;
        string turl_id;

        string origin_data_str;
    };

    struct DeferredDeeplinkData
    {
        int code = -1;

        string sedpLink;
        string turlId;
        string sedpUrlscheme;
    };

    struct DeeplinkData
    {
        int code = -1;

        string sedpLink;
        string turlId;
        string from;
        string baseUrl;
        string url;
        SEJSONObject customParams;
    };

    struct SEPresetProperties
    {
        string appkey;      // The AppKey assigned by SolarEngine (SE)
        string distinctId;  // Device ID generated by SE
        string accountId;   // The account ID passed in by the developer through the login interface
        string visitorId;   // The visitor ID passed in by the developer through the setVisitorID interface
        string sessionId;   // The session ID generated within SE for each cold start
        string uuid;        // Only android
        string imei;        // Only android
        string imei2;       // Only android
        string gaid;        // Only android
        string oaid;        // Only android
        string androidId;   // Only android
        string idfa;        // Only iOS, Device idfa
        string idfv;        // Only iOS, Device idfv
        string ua;          // Device ua
        string language;    // The language of the device's system settings
        string timeZone;    // Device time zone
        string manufacturer; // Device manufacturer
        string platform;    // SDK platform (android:1,iOS:2)
        string osVersion;   // Device system version
        int screenHeight = 0;  // Screen height
        int screenWidth = 0;   // Screen width
        double density = 0.0;  // Only android
        string deviceModel;    // Device model
        int deviceType = 0;    // Device type, 1：android_phone，2：android_pad，3: iphone, 4: ipad, 0: other
        string appVersion;     // Application version number
        int appVersionCode = 0;  // Application build number
        string packageName;    // Application package name
        string appName;        // Application name
        string channel;        // channel (iOS default AppStore)
        string lib;            // (android:1,iOS:2)
        string libVersion;     // SDK version number
    };

    class SolarEngineAPI
    {
    public:
        
        /// Pre-initialize SDK
        /// @param appKey Application appKey. Please contact the business team to obtain it. Must not be empty.
        static void preInit(string appKey);
        
        /// Initialize the SDK
        /// @param appKey Application appKey. Please contact the business team to obtain it. Must not be empty.
        /// @param config Configuration information
        static void init(string appKey, SECConfig config);
        
        /// Whether to enable GDPR region restriction (disabled by default if not set)
        /// @param isGDPRArea YES to enable, NO to disable (when enabled, the SDK will not obtain IDFA/IDFV)
        static void setGDPRArea(bool isGDPRArea);
                
        /// Track a custom event, SECustomEvent is described as follows:
        /// @param eventName Event name. Supports letters (case-sensitive), Chinese characters, digits, and underscores; cannot start with an underscore; length must not exceed 40.
        /// @param customProperties Custom event properties. Keys must not start with an underscore (_).
        /// @param preProperties Preset event properties. Some specific preset properties may start with an underscore
        static void track(SECustomEvent *event);
        
        /// Track an in-app purchase (IAP) event
        /// @param attribute SEPurchaseEvent struct
        static void track(SEPurchaseEvent *event);

        /// Track a monetization ad impression event
        /// @param attribute SEAdImpressionEvent struct
        static void track(SEAdImpressionEvent *event);

        /// Track a monetization ad click event
        /// @param attribute SEAdClickEvent struct
        static void track(SEAdClickEvent *event);
        
        /// Track an attribution event
        /// @param attribute SEAppAttrEvent struct
        static void track(SEAppAttrEvent *event);
        
        /// Track a registration event
        /// @param attribute SERegisterEvent struct
        static void track(SERegisterEvent *event);

        /// Track a login event
        /// @param attribute SELoginEvent struct
        static void track(SELoginEvent *event);
        
        /// Track an order event
        /// @param attribute SEOrderEvent struct
        static void track(SEOrderEvent *event);

        /// Track a first-time event
        static void trackFirstEvent(string eventName, string firstCheckId, const SEJSONObject &properties);
        
        /// Track deeplink-open success. Note: If appDeeplinkOpenURL is called, do not call this API to avoid duplicate events.
        /// @param customProperties Event properties. Keys must not start with an underscore (_).
        static void trackAppReEngagement(const SEJSONObject &customProperties);

        /// Start a duration event (used together with -eventFinish:properties:)
        /// @param eventName Event name. Supports letters (case-sensitive), Chinese characters, digits, and underscores; cannot start with an underscore; length must not exceed 40.
        static void eventStart(string eventName);
        
        /// End and track a duration event (used together with -eventStart:)
        /// @param eventName Event name. Supports letters (case-sensitive), Chinese characters, digits, and underscores; cannot start with an underscore; length must not exceed 40.
        /// @param properties Custom properties
        static void eventFinish(string eventName, const SEJSONObject &properties);

        /// Set preset event properties
        /// @param eventType Event type
        /// @param properties Event properties
        static void setPresetEvent(SECPresetEventType eventType, const SEJSONObject &properties);

        /// Get SDK preset properties
        static SEPresetProperties getPresetProperties();
        
        /// Get attribution data
        /// If returns code is -1,   there is no attribution result
        static AttributionData getAttributionData();

        // When the app is opened via Deeplink (Universal Link or URL Scheme), pass the URL to the SDK
        // @param url from the system callback
        static void appDeeplinkOpenURL(string url);
        
        /// Set visitor ID
        /// @param visitorId Visitor ID
        static void setVisitorID(string visitorId);
        
        /// Get visitor ID
        static string getVisitorID();
        
        /// Log in and set account ID
        /// @param accountId Account ID
        static void loginWithAccountID(string accountId);
        
        /// Account ID
        static string getAccountID();
        
        /// Log out and clear account ID
        static void logout();
        
        /// Get distinctId, The unique ID generated by the SolarEngine SDK
        static string getDistinctId();
        
        //set Gaid , only android support
        static void setGaid(string gaid);
        //set channel , only android support
        static void setChannel(string channel);
        
        /// SolarEngine wrapper for the system API requestTrackingAuthorizationWithCompletionHandler, only iOS support
        /// @param completion Callback user authorization status:
        /// 0: Not Determined;
        /// 1: Restricted;
        /// 2: Denied;
        /// 3: Authorized;
        /// 999: system error
        static void requestTrackingAuthorization(std::function<void(int status)> completionHandler);

        /// Set super properties
        /// @param properties Custom properties
        static void setSuperProperties(const SEJSONObject &properties);
        
        /// Unset a specific super property
        /// @param key Super property key
        static void unsetSuperProperty(string key);
        
        /// Clear all super properties
        static void clearSuperProperties();
        
        /// Initialize user properties. If a property already exists, its value will not be modified; otherwise it will be created.
        /// @param properties Custom properties
        static void userInit(const SEJSONObject &properties);
        
        /// Update user properties. Existing property values will be overwritten; if not present, they will be created.
        /// @param properties Custom properties
        static void userUpdate(const SEJSONObject &properties);
        
        /// Increment user properties
        /// @param properties Custom properties (only numeric keys will be incremented)
        static void userAdd(const SEJSONObject &properties);
        
        /// Reset user properties. Clear the specified properties.
        /// @param keys Array of property keys
        static void userUnset(const vector<string> &keys);
        
        /// Append user properties
        /// @param properties Custom properties
        static void userAppend(const SEJSONObject &properties);
        
        /// Delete user
        /// @param deleteType Type of deletion
        /// SEUserDeleteTypeByAccountId: Delete user by AccountId
        /// SEUserDeleteTypeByVisitorId: Delete user by VisitorId
        static void userDelete(SECDeleteType deleteType);

        /// Flush events immediately
        static void reportEventImmediately();

        
        /// Set the SDK initialization callback
        /// Code description:
        /// 0: Initialization succeeded
        /// Non-zero indicates initialization failed, as follows:
        /// 101: Initialization failed because pre-initialization was not called
        /// 102: Initialization failed because appKey is invalid
        static void setInitCallback(std::function<void(int)> callback);
        
        
        /// Set the callback to obtain attribution results. Set this before initializing the SDK.
        /// Invoked when an attribution result is available or when retrieval fails. error.code as described above.
        
         /// Code description:
        /// 0: Successfully obtained attribution result; see attributionData
        /// Non-zero indicates failure to obtain attribution result, as follows:
        /// 100: _appKey is invalid
        /// 101: _distinct_id is invalid
        /// 102: _distinct_id_type is invalid
        /// 1001: Network error; SDK failed to connect to the server
        /// 1002: Exceeded 10 requests in the current launch without obtaining attribution result
        /// 1003: Less than 5 minutes since last polling for attribution; please try again after 5 minutes
        /// 1004: The user has not obtained attribution for over 15 days; no further requests will be made during this installation
        static void setAttributionDataCallback(std::function<void(const AttributionData &)> callback);
        
        /// Set deferred deeplink callback. Call this before SDK initialization. Only when SECConfig.enableDeferredDeeplink is set to true will the SDK request deferred deeplink and trigger this callback.
        /// Callback codes:
        ///    0:  success
        /// 1101: SDK internal error;
        /// 1102: Failed to connect to server;
        /// 1103: Connection to server timed out;
        /// 1104: Server error;
        /// 1105: Server returned SDK-side data;
        /// 1106: Deeplink match failed, server returned empty
        static void setDeferredDeeplinkCallback(std::function<void(const DeferredDeeplinkData &)> callback);
        
        /// Set the callback for parameters when the app is opened via Deeplink
        /// Callback codes:
        /// 0 : success;
        /// 1 : URL invalid or empty;
        /// 2 : URL parameter parse error
        static void setDeeplinkCallback(std::function<void(const DeeplinkData &)> callback);

        /// Set default configuration. If the server configuration does not match, the default will be used as a fallback.
        /// @param defaultConfig Default configuration. Each parameter is a SECRemoteConfigItem .
        static void setDefaultRemoteConfig(const vector<SECRemoteConfigItem> &defaultConfig);
        
        /// Set custom event properties. The backend will use these properties for matching when requesting configuration.
        /// @param properties Custom event properties, corresponding to the properties configured on the admin page
        static void setRemoteConfigEventProperties(const SEJSONObject &properties);
        
        /// Set custom user properties. The backend will use these properties for matching when requesting configuration.
        /// @param properties Custom user properties, corresponding to the properties configured on the admin page
        static void setRemoteConfigUserProperties(const SEJSONObject &properties);
        
        /// Synchronously fetch a parameter configuration.
        /// Priority: cache first; if not found, use default config; if still not found, return "".
        /// @param key  Parameter key configured on the admin page; returns the corresponding value if matched
        static string fastFetchRemoteConfig(const string &key);
        
        /// Synchronously fetch all parameter configurations.
        /// Includes both default and cached configurations.
        static SEJSONObject fastFetchAllRemoteConfig();
        
        /// Asynchronously fetch a parameter configuration.
        /// The server configuration will be requested and merged with local cache; query from cache first, then default config; return "" if not found.
        /// @param key  Parameter key configured on the admin page; returns the corresponding value if matched
        static void asyncFetchRemoteConfig(const string &key, std::function<void(const string &)> completionHandler);
        
        /// Asynchronously fetch all parameter configurations.
        /// The server configuration will be requested and merged with local cache; query from cache first, then default config; return nil if not found.
        static void asyncFetchAllRemoteConfig(std::function<void(const SEJSONObject &)> completionHandler);
        
        
        
        static string se_configToJsonString(SECConfig config);
        static void se_onInitCallback(int resultCode);
        static void se_onAttributionDataCallback(const AttributionData &data);
        static void se_onDeferredDeeplinkCallback(const DeferredDeeplinkData &data);
        static void se_onDeeplinkCallback(const DeeplinkData &data);
    private:
        static std::function<void(int)> se_initCallback;
        static std::function<void(const AttributionData &)> se_attributionDataCallback;
        static std::function<void(const DeferredDeeplinkData &)> se_deferredDeeplinkCallback;
        static std::function<void(const DeeplinkData &)> se_deeplinkCallback;
    };
}

#endif

