local SolarEngineSDK = {}
local LIB_VERSION = "1.0.0"
local TYPE = "Corona"
local json = require("json")

SELogger = {
    enabled = false -- 默认关闭
}


local function _init()
    local environment = system.getInfo("environment")
    if environment == "device" then
        local platform = system.getInfo("platform")
        if platform == "ios" then
            SolarEngineSDK.library = require("se.plugin.library")
        elseif platform == "android" then
            SolarEngineSDK.library = require("plugin.library")
        else
            print("[SolarEngine] Warning: current platform is < " .. platform .. " >, Event tracking is not supported.")
        end
    else
        print("[SolarEngine] Warning: current environment is < " .. environment .. " >, Event tracking is not supported.")
    end
end
-- 定义枚举
SolarEngineSDK.eventType = {

    Install = 0,
    Start = 1,
    End = 2,
    All = 3,
}
SolarEngineSDK.userDeleteType = {
    byAccountId = 0,
    byVisitorId = 1
}
SolarEngineSDK.mergeType = {
    byUser=0,
    byDefault=1
}

function SELogger.init(config)
    if config and config.logEnabled then
        SELogger.enabled = true
    else
        SELogger.enabled = false
    end
end

function SELogger.log(tag, msg)
    if SELogger.enabled then
        print(string.format("[SE.CoronaiOSSDK][SolarEngineSDK] ✅ [%s] %s", tag or "LOG", msg or ""))
    end
end


-- 预初始化
SolarEngineSDK.preinit = function(appkey)
    SELogger.log("preinit called")
    SolarEngineSDK.library.preinit(appkey)

end
-- 初始化 SDK
SolarEngineSDK.initSdk = function(config)
SELogger.init(config)
    local configStr = json.encode(config)
    local properties={
        subLibVersion =LIB_VERSION,
        sdkType =TYPE

    }
    SELogger.log("initSdk", "config = " .. configStr)

    local propertiesStr = json.encode(properties)
    SolarEngineSDK.library.initSdk(configStr,propertiesStr)
end

SolarEngineSDK.setInitCompletedCallback = function(callback)
    SELogger.log("setInitCompletedCallback called")
    SolarEngineSDK.library.setInitCompletedCallback(callback)
end
SolarEngineSDK.setAttributionCallback = function(callback)
    SELogger.log("setAttributionCallback called")
    SolarEngineSDK.library.setAttributionCallback(callback)
end
SolarEngineSDK.setDeepLinkCallback = function(callback)
    SELogger.log("setDeepLinkCallback called")
    SolarEngineSDK.library.setDeepLinkCallback(callback)
end
SolarEngineSDK.setDeferredDeepLinkCallback = function(callback)
    SELogger.log("setDeferredDeepLinkCallback called")
    SolarEngineSDK.library.setDeferredDeepLinkCallback(callback)
end
SolarEngineSDK.requestTrackingAuthorization = function(callback)
    SELogger.log("requestTrackingAuthorization called")
    SolarEngineSDK.library.requestTrackingAuthorization(callback)
end

 SolarEngineSDK.login = function(loginid)
    SELogger.log("login called")
    SolarEngineSDK.library.login(loginid)
end
 SolarEngineSDK.logout = function()
    SELogger.log("logout called")
    SolarEngineSDK.library.logout()
end
SolarEngineSDK.setVisitorId = function(visitorID)
    SELogger.log("setVisitorId called")
    SolarEngineSDK.library.setVisitorId(visitorID)
end

SolarEngineSDK.getDistinctId = function()
    SELogger.log("getDistinctId called")
    return SolarEngineSDK.library.getDistinctId()
end
SolarEngineSDK.getAccountId = function()
    SELogger.log("getAccountId called")
    return SolarEngineSDK.library.getAccountId()
end
SolarEngineSDK.getVisitorId = function()
    SELogger.log("getVisitorId called")
    return SolarEngineSDK.library.getVisitorId()
end
SolarEngineSDK.setChannel = function(channel)
    SELogger.log("setChannel called")
    SolarEngineSDK.library.setChannel(channel)
end
SolarEngineSDK.setOaid = function(oaid)
    SELogger.log("setOaid called")
    SolarEngineSDK.library.setOaid(oaid)
end
SolarEngineSDK.setGDPRArea = function(isGDPRArea)
    SELogger.log("setGDPRArea called")
    SolarEngineSDK.library.setGDPRArea(isGDPRArea)
end

SolarEngineSDK.setGaid = function(gaid)
    SELogger.log("setGaid called")
    SolarEngineSDK.library.setGaid(gaid)
end

SolarEngineSDK.setPresetEvent = function(eventType, properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("setPresetEvent", "eventType = " .. eventType .. ", properties = " .. propertiesStr)
    SolarEngineSDK.library.setPresetEvent(eventType, propertiesStr)

end

SolarEngineSDK.setSuperProperties = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("setSuperProperties", "properties = " .. propertiesStr)
    SolarEngineSDK.library.setSuperProperties(propertiesStr)
end
SolarEngineSDK.unsetSuperProperty = function(propertyName)
    SELogger.log("unsetSuperProperty", "propertyName = " .. propertyName)
    SolarEngineSDK.library.unsetSuperProperty(propertyName)
end
SolarEngineSDK.clearSuperProperties = function()
    SELogger.log("clearSuperProperties")
    SolarEngineSDK.library.clearSuperProperties()
end
SolarEngineSDK.getPresetProperties = function()
    SELogger.log("getPresetProperties")
    return SolarEngineSDK.library.getPresetProperties()
end

SolarEngineSDK.userInit = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("userInit", "properties = " .. propertiesStr)
    SolarEngineSDK.library.userInit(propertiesStr)
end
SolarEngineSDK.userUpdate = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("userUpdate", "properties = " .. propertiesStr)
    SolarEngineSDK.library.userUpdate(propertiesStr)
end
SolarEngineSDK.userUnset = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("userUnset", "properties = " .. propertiesStr)
    SolarEngineSDK.library.userUnset(propertiesStr)
end
SolarEngineSDK.userAdd = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("userAdd", "properties = " .. propertiesStr)
    SolarEngineSDK.library.userAdd(propertiesStr)
end
SolarEngineSDK.userAppend = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("userAppend", "properties = " .. propertiesStr)
    SolarEngineSDK.library.userAppend(propertiesStr)
end
SolarEngineSDK.userDelete = function(type)
    SELogger.log("userDelete", "type = " .. type)
    SolarEngineSDK.library.userDelete(type)
    
end
SolarEngineSDK.trackAdImpression = function(properties)
    local propertiesStr = json.encode(properties)
    SolarEngineSDK.library.trackAdImpression(propertiesStr)
end
SolarEngineSDK.trackAdClick = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("trackAdClick", "properties = " .. propertiesStr)
    SolarEngineSDK.library.trackAdClick(propertiesStr)
end
SolarEngineSDK.trackPurchase = function(properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("trackPurchase", "properties = " .. propertiesStr)
    SolarEngineSDK.library.trackPurchase(propertiesStr)
end
SolarEngineSDK.trackRegister = function(properties)
    local propertiesStr = json.encode(properties)
     SELogger.log("trackRegister", "properties = " .. propertiesStr)
    SolarEngineSDK.library.trackRegister(propertiesStr)
end
SolarEngineSDK.trackLogin = function(properties)
    local propertiesStr = json.encode(properties)
     SELogger.log("trackLogin", "properties = " .. propertiesStr)
    SolarEngineSDK.library.trackLogin(propertiesStr)
end
SolarEngineSDK.trackOrder = function(properties)
    local propertiesStr = json.encode(properties)
     SELogger.log("trackOrder", "properties = " .. propertiesStr)
    SolarEngineSDK.library.trackOrder(propertiesStr)
end
SolarEngineSDK.trackAppAttr = function(properties)
    local propertiesStr = json.encode(properties)
     SELogger.log("trackAppAttr", "properties = " .. propertiesStr)
    SolarEngineSDK.library.trackAttribution(propertiesStr)
end
SolarEngineSDK.track = function(eventName, properties)
    local propertiesStr = json.encode(properties)
     SELogger.log("track", "eventName = " .. eventName .. ", properties = " .. propertiesStr)
    SolarEngineSDK.library.track(eventName, propertiesStr)
end
SolarEngineSDK.track = function(eventName, properties, preAttributes)
    local propertiesStr = json.encode(properties)
    local preAttributesStr = json.encode(preAttributes)
     SELogger.log("track", "eventName = " .. eventName .. ", properties = " .. propertiesStr)
    SolarEngineSDK.library.track(eventName, propertiesStr, preAttributesStr)
end

SolarEngineSDK.eventStart = function(eventName)
    SELogger.log("eventStart", "eventName = " .. eventName)
    SolarEngineSDK.library.eventStart(eventName)

end
SolarEngineSDK.eventFinish = function(eventName, properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("eventFinish", "eventName = " .. eventName .. ", properties = " .. propertiesStr)
    SolarEngineSDK.library.eventFinish(eventName, propertiesStr)
end
SolarEngineSDK.trackAppReEngagement = function(customProperties)
    local propertiesStr = json.encode(customProperties)
    SELogger.log("trackAppReEngagement", "properties = " .. propertiesStr)
    SolarEngineSDK.library.trackAppReEngagement(propertiesStr)
end
SolarEngineSDK.trackFirstEvent = function(eventName,firstCheckId,properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("trackFirstEvent", "eventName = " .. eventName .. ", firstCheckId = " .. firstCheckId .. ", properties = " .. propertiesStr)
    SolarEngineSDK.library.trackFirstEvent(eventName,firstCheckId,propertiesStr)
end
SolarEngineSDK.reportEventImmediately = function()
    SELogger.log("reportEventImmediately")
    SolarEngineSDK.library.reportEventImmediately()
end
SolarEngineSDK.getAttributionData = function()
    SELogger.log("getAttributionData")
    return SolarEngineSDK.library.getAttributionData()
end


-----------------------------------------------------------------------RC----------------------------------------------------------------------------

function SolarEngineSDK.stringItem(name, value)
    return { name = name, value = value, type = 1 }
end

function SolarEngineSDK.intItem(name, value)
    return { name = name, value = value, type = 2 }
end

function SolarEngineSDK.boolItem(name, value)
    return { name = name, value = value, type = 3 }
end

function SolarEngineSDK.jsonItem(name, value)
    return { name = name, value = value, type = 4 }
end


SolarEngineSDK.setRemoteDefaultConfig = function(item)
    local itemstr = json.encode(item)
    SELogger.log("setRemoteDefaultConfig", "item = " .. itemstr)
    SolarEngineSDK.library.setRemoteDefaultConfig(itemstr)
end
SolarEngineSDK.setRemoteConfigEventProperties = function( properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("setRemoteConfigEventProperties", "properties = " .. propertiesStr)
    SolarEngineSDK.library.setRemoteConfigEventProperties(propertiesStr)
end
SolarEngineSDK.setRemoteConfigUserProperties = function(  properties)
    local propertiesStr = json.encode(properties)
    SELogger.log("setRemoteConfigUserProperties", "properties = " .. propertiesStr)
    SolarEngineSDK.library.setRemoteConfigUserProperties(propertiesStr)
end
SolarEngineSDK.fastFetchRemoteConfig = function(key)
    SELogger.log("fastFetchRemoteConfig", "key = " .. key)
    return SolarEngineSDK.library.fastFetchRemoteConfig(key)
end
SolarEngineSDK.fastAllFetchRemoteConfig = function()
    SELogger.log("fastAllFetchRemoteConfig")
    return SolarEngineSDK.library.fastAllFetchRemoteConfig()
end
SolarEngineSDK.asyncFetchRemoteConfig = function(key,callback)
    SELogger.log("asyncFetchRemoteConfig", "key = " .. key)
    SolarEngineSDK.library.asyncFetchRemoteConfig(key,callback)
end
SolarEngineSDK.asyncAllFetchRemoteConfig = function(callback)
    SELogger.log("asyncAllFetchRemoteConfig")
    SolarEngineSDK.library.asyncAllFetchRemoteConfig(callback)
end


_init()
return SolarEngineSDK
