//
//  SEPluginLibrary.h
//  App
//
//  Created by iMengqing on 2025/9/29.
//

  

#include <CoronaLua.h>
#include <CoronaMacros.h>
class SEPluginLibrary
{
protected:
        static int Finalizer( lua_State *L );

public:
    typedef SEPluginLibrary Self;
    static int Open( lua_State *L );

    static const char kName[];
    static const char kEvent[];
    static Self *ToLibrary( lua_State *L );
public:
    
    static int preinit(lua_State *L);
    static int initSdk(lua_State *L);
    static int setInitCompletedCallback (lua_State *L);
    static int setAttributionCallback (lua_State *L);
    static int setDeepLinkCallback(lua_State *L);
    static int setDeferredDeepLinkCallback(lua_State *L);
    static int requestTrackingAuthorization(lua_State *L);


    
    static int login(lua_State *L);
    static int logout(lua_State *L);
    static int setVisitorId(lua_State *L);
    static int getDistinctId(lua_State *L);
    static int getAccountId(lua_State *L);
    static int getVisitorId(lua_State *L);
    static int setChannel(lua_State *L);
    static int setOaid (lua_State *L);
    static int setGDPRArea (lua_State *L);
    static int setGaid (lua_State *L);
 
    static int setPresetEvent(lua_State *L);
    static int setSuperProperties(lua_State *L);
    static int unsetSuperProperty(lua_State *L);
    static int clearSuperProperties(lua_State *L);
    static int getPresetProperties(lua_State *L);
    static int userInit(lua_State *L);
    static int userUpdate(lua_State *L);
    static int userUnset(lua_State *L);
    static int userAdd(lua_State *L);
    static int userAppend(lua_State *L);
    static int userDelete(lua_State *L);
    static int trackAdImpression(lua_State *L);
    static int trackAdClick(lua_State *L);
    static int trackPurchase(lua_State *L);
    static int trackRegister(lua_State *L);
    static int trackLogin(lua_State *L);
    static int trackOrder(lua_State *L);
    static int trackAttribution(lua_State *L);
    static int track(lua_State *L);
    static int eventStart(lua_State *L);
    static int eventFinish(lua_State *L);
    static int trackAppReEngagement(lua_State *L);
    static int trackFirstEvent(lua_State *L);
    static int reportEventImmediately(lua_State *L);
    static int getAttributionData(lua_State *L);

public:
    static int setRemoteDefaultConfig(lua_State *L);

    static int setRemoteConfigEventProperties(lua_State *L);
    static int setRemoteConfigUserProperties(lua_State *L);


    static int fastFetchRemoteConfig(lua_State *L);
    static int fastAllFetchRemoteConfig(lua_State *L);
    static int asyncFetchRemoteConfig(lua_State *L);
    static int asyncAllFetchRemoteConfig(lua_State *L);


    







    static int init(lua_State *L);   //
    static int show(lua_State *L);
    static int hello(lua_State *L);

    // 其他方法...
};
CORONA_EXPORT int luaopen_se_plugin_library(lua_State *L);
