// Copyright 2025 SolarEngine. All Rights Reserved.
#include "SELog.h"

DEFINE_LOG_CATEGORY_STATIC(SEAnalyticsLog, Log, All);

void FSELog::Warning(const FString CurLogPosition, const FString& LogStr)
{
    if (m_Enable)
    {
        SELogWarn(SEAnalyticsLog, FString::Printf(TEXT("%s --- %s/"), *CurLogPosition, *LogStr));
        ScreenWarn(FString::Printf(TEXT("%s --- %s"), *CurLogPosition, *LogStr));
    }
}

void FSELog::Warning(const FString CurLogPosition, const int& LogStr)
{
    if (m_Enable)
    {
        SELogWarn(SEAnalyticsLog, FString::Printf(TEXT("%s --- %d"), *CurLogPosition, LogStr));
        ScreenWarn(FString::Printf(TEXT("%s --- %d"), *CurLogPosition, LogStr));
    }
}

void FSELog::Error(const FString CurLogPosition, const FString& LogStr)
{
    SELogError(SEAnalyticsLog, FString::Printf(TEXT("%s --- %s"), *CurLogPosition, *LogStr));
    ScreenError(FString::Printf(TEXT("%s --- %s"), *CurLogPosition, *LogStr));
}

void FSELog::Error(const FString CurLogPosition, const int& LogStr)
{
    SELogError(SEAnalyticsLog, FString::Printf(TEXT("%s --- %d"), *CurLogPosition, LogStr));
    ScreenError(FString::Printf(TEXT("%s --- %d"), *CurLogPosition, LogStr));
}

void FSELog::Info(const FString CurLogPosition, const FString& LogStr)
{
    if (m_Enable)
    {
        SELogInfo(SEAnalyticsLog, FString::Printf(TEXT("%s --- %s"), *CurLogPosition, *LogStr));
        ScreenLog(FString::Printf(TEXT("%s --- %s"), *CurLogPosition, *LogStr));
    }
}

void FSELog::SEInfo(const FString CurLogPosition, const FString& LogStr)
{
   
        SELogInfo(SEAnalyticsLog, FString::Printf(TEXT("%s --- %s"), *CurLogPosition, *LogStr));
    
}


void FSELog::Info(const FString CurLogPosition, const int& LogStr)
{
    if (m_Enable)
    {
        SELogInfo(SEAnalyticsLog, FString::Printf(TEXT("%s --- %d"), *CurLogPosition, LogStr));
        ScreenLog(FString::Printf(TEXT("%s --- %d"), *CurLogPosition, LogStr));
    }
}

void FSELog::SetEnableLog(bool Enable)
{
    m_Enable = Enable;
}
