//
//  SEUtil.cpp
//  iMengqingDemo (IOS)
//
//  Created by iMengqing on 2025/8/13.
//  Copyright © 2025 Epic Games, Inc. All rights reserved.
//
#include "SEUtil.h"

// FSEConfig.cpp

#include "JsonObjectConverter.h"
#include "Serialization/JsonWriter.h"
#include "Serialization/JsonSerializer.h"


FString FSEUtil::FSERConfigToJsonString(const FSECRemoteConfig& Config)
{
	TSharedPtr<FJsonObject> RemoteConfigObj = MakeShared<FJsonObject>();
	
	if (Config.enable)
	{
		RemoteConfigObj->SetBoolField(TEXT("enable"), Config.enable);
		RemoteConfigObj->SetNumberField(TEXT("mergeType"),
			static_cast<int32>(Config.mergeType));
		// 处理 TSharedPtr<FJsonObject> 字段（如果为空则创建空对象）
		RemoteConfigObj->SetObjectField(TEXT("customIDProperties"),
		                                Config.customIDProperties.IsValid()
			                                ? Config.customIDProperties.ToSharedRef()
			                                : MakeShared<FJsonObject>());

		RemoteConfigObj->SetObjectField(TEXT("customIDEventProperties"),
		                                Config.customIDEventProperties.IsValid()
			                                ? Config.customIDEventProperties.ToSharedRef()
			                                : MakeShared<FJsonObject>());

		RemoteConfigObj->SetObjectField(TEXT("customIDUserProperties"),
		                                Config.customIDUserProperties.IsValid()
			                                ? Config.customIDUserProperties.ToSharedRef()
			                                : MakeShared<FJsonObject>());

	}else
		RemoteConfigObj->SetBoolField(TEXT("enable"), false);

	return ToJsonString(RemoteConfigObj);
}

FString FSEUtil::ToJsonString(const TSharedPtr<FJsonObject>& JsonObject)
{
    if (!JsonObject.IsValid())
           {
               return TEXT("{}"); // 空 JSON
           }

           FString JsonString;
           TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&JsonString);
           if (FJsonSerializer::Serialize(JsonObject.ToSharedRef(), Writer))
           {
               return JsonString;
           }

           // 序列化失败时返回空 JSON
           return TEXT("{}");
}



FString FSEUtil::FirstEventToJsonString(const FSEBaseAttributes& att)
{
	TSharedPtr<FJsonObject> JsonObject = MakeShared<FJsonObject>();
	JsonObject->SetStringField(TEXT("checkId"), att.checkId);

	switch (att.GetType())
	{
	case ESEFirstEventType::Register:
		{
			const FRegisterEventAttributes& regAttr = static_cast<const FRegisterEventAttributes&>(att);

			JsonObject->SetStringField(TEXT("registerType"), regAttr.registerType);
			JsonObject->SetStringField(TEXT("registerStatus"), regAttr.registerStatus);
			JsonObject->SetStringField(TEXT("eventType"), "_appReg");
			JsonObject->SetObjectField(
				TEXT("customProperties"),
				regAttr.customProperties.IsValid() ? regAttr.customProperties : MakeShared<FJsonObject>()
			);
			break;
		}
	
	case ESEFirstEventType::Custom:
		{
			const FCustomAttributes& customAttr = static_cast<const FCustomAttributes&>(att);
			JsonObject->SetStringField(TEXT("customEventName"), customAttr.customEventName);
			JsonObject->SetObjectField(
				TEXT("customProperties"),
				customAttr.customProperties.IsValid() ? customAttr.customProperties : MakeShared<FJsonObject>()
			);

//			JsonObject->SetObjectField(
//				TEXT("preProperties"),
//				customAttr.preProperties.IsValid() ? customAttr.preProperties : MakeShared<FJsonObject>()
//			);
			JsonObject->SetStringField(TEXT("eventType"), "_customEvent");
			break;
		}
		
	}
	return ToJsonString(JsonObject);
}

FString FSEUtil::getRemoteDefaultConfigJsonString(const std::vector<Item>& defaultConfig)
{
    TArray<TSharedPtr<FJsonValue>> jsonArray;

    for (const auto& item : defaultConfig)
    {
        switch (item.type)
        {
        case 1: // string
        {
            TSharedPtr<FJsonObject> jsonItemString = MakeShared<FJsonObject>();
            jsonItemString->SetStringField(TEXT("name"), FString(item.name));
            jsonItemString->SetNumberField(TEXT("type"), item.type);
            jsonItemString->SetStringField(TEXT("value"), FString(item.value.Get<FString>()));  // ✅
            jsonArray.Add(MakeShared<FJsonValueObject>(jsonItemString));
            break;
        }
        case 2: // int
        {
            TSharedPtr<FJsonObject> jsonItemInt = MakeShared<FJsonObject>();
            jsonItemInt->SetStringField(TEXT("name"), FString(item.name));
            jsonItemInt->SetNumberField(TEXT("type"), item.type);
            jsonItemInt->SetNumberField(TEXT("value"), item.value.Get<int>());  // ✅
            jsonArray.Add(MakeShared<FJsonValueObject>(jsonItemInt));
            break;
        }
        case 3: // bool
        {
            TSharedPtr<FJsonObject> jsonItemBool = MakeShared<FJsonObject>();
            jsonItemBool->SetStringField(TEXT("name"), FString(item.name));
            jsonItemBool->SetNumberField(TEXT("type"), item.type);
            jsonItemBool->SetBoolField(TEXT("value"), item.value.Get<bool>());  // ✅
            jsonArray.Add(MakeShared<FJsonValueObject>(jsonItemBool));
            break;
        }
        case 4: // json
        {
            TSharedPtr<FJsonObject> jsonItemJson = MakeShared<FJsonObject>();
            jsonItemJson->SetStringField(TEXT("name"), FString(item.name));
            jsonItemJson->SetNumberField(TEXT("type"), item.type);
            jsonItemJson->SetObjectField(TEXT("value"), item.value.Get<TSharedPtr<FJsonObject>>());  // ✅
            jsonArray.Add(MakeShared<FJsonValueObject>(jsonItemJson));
            break;
        }
        default:
            UE_LOG(LogTemp, Warning, TEXT("SetRemoteDefaultConfig: Unknown item type for %s"), *FString(item.name));
            break;
        }
    }

    FString OutputString;
    TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&OutputString);
    FJsonSerializer::Serialize(MakeShared<FJsonValueArray>(jsonArray)->AsArray(), Writer);

//    UE_LOG(LogTemp, Warning, TEXT("RemoteConfig JSON: %s"), *OutputString);
    return OutputString;
}
// FString FSEUtil::getRemoteDefaultConfigJsonString(const std::vector<Item>& defaultConfig)
// {
// 	// 创建一个 JSON 对象存放全部配置
// 	TArray<TSharedPtr<FJsonValue>> jsonArray;
//
// 	for (const auto& item : defaultConfig)
// 	{
// 		switch (item.type)
// 		{
// 		case 1:
// 			{
// 				TSharedPtr<FJsonObject> jsonItemString = MakeShared<FJsonObject>();
// 				jsonItemString->SetStringField(TEXT("name"), item.name);
// 				jsonItemString->SetNumberField(TEXT("type"),item.type );
//                 jsonItemString->SetStringField(TEXT("value"), FString(std::get<std::string>(item.value).c_str()));
// 				jsonArray.Add(MakeShared<FJsonValueObject>(jsonItemString));
// 				break;
// 			}
// 		
// 		case 2:
// 			{
// 				TSharedPtr<FJsonObject> jsonItemInt = MakeShared<FJsonObject>();
// 				jsonItemInt->SetStringField(TEXT("name"), item.name);
// 				jsonItemInt->SetNumberField(TEXT("type"),item.type );
// 				jsonItemInt->SetNumberField(TEXT("value"), std::get<int>(item.value));
// 				jsonArray.Add(MakeShared<FJsonValueObject>(jsonItemInt));
// 				break;
// 			}
// 		
// 		case 3:
// 			{
// 				TSharedPtr<FJsonObject> jsonItemBool = MakeShared<FJsonObject>();
// 				jsonItemBool->SetStringField(TEXT("name"), item.name);
// 				jsonItemBool->SetNumberField(TEXT("type"),item.type );
// 				jsonItemBool->SetBoolField(TEXT("value"), std::get<bool>(item.value));
// 				jsonArray.Add(MakeShared<FJsonValueObject>(jsonItemBool));
// 				break;
// 			}
// 		
// 		case 4: 
// 			{
// 				TSharedPtr<FJsonObject> JsonRoot = MakeShared<FJsonObject>();
// 				JsonRoot->SetStringField(TEXT("name"), item.name);
// 				JsonRoot->SetNumberField(TEXT("type"),item.type );
// 				JsonRoot->SetObjectField(TEXT("value"), std::get<TSharedPtr<FJsonObject>>(item.value));
// 				jsonArray.Add(MakeShared<FJsonValueObject>(JsonRoot));
// 				break;
// 				
// 			}
// 		default:
// 			UE_LOG(LogTemp, Warning, TEXT("SetRemoteDefaultConfig: Unknown item type for %s"), *FString(item.name.c_str()));
// 			break;
// 		}
// 	}
// 	FString OutputString;
// 	TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&OutputString);
// 	FJsonSerializer::Serialize(MakeShared<FJsonValueArray>(jsonArray)->AsArray(), Writer);
//
// 	UE_LOG(LogTemp, Warning, TEXT("RemoteConfig JSON: %s"), *OutputString);
// 	return OutputString;
// 	
// 	
// }


