//// Copyright 2020 Thinking Data Ltd. All Rights Reserved.
//
//#import <vector>
//#import <string>
#include "SEAnalytics.h"
#include "Common/SELog.h"
//
//DECLARE_DELEGATE_RetVal_TwoParams(FString, TAAutoTrackEventRetValDelegate, FString, FString);
//static TMap<FString, TAAutoTrackEventRetValDelegate> TAAutoTrackEventIOSMethods;
//
class SEAnalyticsCpp
{
public:
    
    static void se_preInit(FString appkey);
    static void se_init(FString appkey, FSEConfig config,FSECRemoteConfig rcConfig);
    static void se_setVisitorID(FString visitorId);

    static FString se_getDistinctId();
    static FString se_getVisitorID();
	static FString se_getAccountId();
	static void se_setGDPRArea(bool isGDPRArea);
    
    static void se_track(FString eventName, FString customAttributes, FString preAttributes);
    
    static void se_trackIAPWithAttributes(FSEPurchaseEventAttributes attr);
    static void se_trackAdImpressionWithAttributes(FImpressionAttributes att);
    static void se_trackAdClickWithAttributes(FAdClickAttributes att);
    static void se_trackAppAttrWithAttributes(FSEAttAttributes att);
    static void se_trackRegisterWithAttributes(FRegisterEventAttributes att);
    static void se_trackLoginWithAttributes(FLoginEventAttributes att);
    static void se_trackOrderWithAttributes(FOrderEventAttributes att);
    static void se_eventStart(FString eventName);
    static void se_eventFinish(FString eventName, FString propertiesJson);
    static void se_trackFirst( FString  att );
    static void se_trackAppReEngagement(FString att);

    static void se_reportEventImmediately();
   
    static void se_userInit(FString properties);
    static void se_userUpdate(FString properties);
    static void se_userAdd(FString properties);
    static void se_userUnset(TArray<FString> keys );
    static void se_userAppend(FString properties);
    static void se_userDelete(int deleteType);
    
    static void se_setSuperProperties(FString properties);
    static void se_unsetSuperProperty(FString property);
    static void se_setPresetEvent(ESEPresetEventType EventType, FString properties);
    
    static TSharedPtr<FJsonObject> se_getPresetProperties();
    static void se_loginWithAccountID(FString accountId);
    static void se_logout();

 
    static TSharedPtr<FJsonObject>  se_getAttributionData();


    //在线参数
    static void se_setRemoteConfigEventProperties(FString Properties);
    static void se_setRemoteConfigUserProperties(FString Properties);
    static void se_setRemoteDefaultConfig(FString config);
    static void se_asyncAllFetchRemoteConfig( FonFetchAllRemoteConfigCallback callback );
    static void se_asyncFetchRemoteConfig( const FString&key, FonFetchRemoteConfigCallback  callback );
    static TSharedPtr<FJsonObject> se_fastAllFetchRemoteConfig();
    static FString se_fastFetchRemoteConfig(const FString&key);




    static void se_setDeferredDeeplinkCallback(const FDeferredDeeplinkCallBack& callback);
    static void se_setDeepLinkCallBack  (const FDeeplinkCallBack& callback);
    static void se_appDeeplinkOpenURL(FString url);
  static void se_requestTrackingAuthorization(const FonRequestTrackingAuthorizationCallback & callback);
    
private:
    static void se_setInitCompletedCallback(const FInitCompletedCallback& callback);
    static void se_setAttributionCallback(const FAttributionCallback& callback) ;
    static TSharedPtr<FJsonValue> ConvertNSObjectToFJsonValue(id value);
    static FString ConvertNSObjectToFString(id value);

    
};
