#include "UESEAnalytics.h"
#include "SEAnalytics.h"
#include "Common/SELog.h"
#if PLATFORM_IOS
#import <SolarEngineSDK/SolarEngineSDK.h>
#include "IOS/IOSAppDelegate.h"
#endif
void FSEAnalyticsModule::StartupModule()
{

#if PLATFORM_IOS
    // 注册 openURL 回调
    FIOSCoreDelegates::OnOpenURL.AddLambda([](UIApplication* Application, NSURL* URL, NSString* SourceApplication, id Annotation)
    {
        
        FString UrlString(URL.absoluteString);
        USEAnalytics::appDeeplinkOpenURL(UrlString);

        FString Msg = FString::Printf(TEXT("openURL called: %s"), *UrlString);
        FSELog::SEInfo(CUR_LOG_POSITION, *Msg);
    });
#endif


    // 模块启动时执行的代码
    FSELog::SEInfo(CUR_LOG_POSITION, TEXT("[SolarEngine] Module started"));
}

void FSEAnalyticsModule::ShutdownModule()
{

    FSELog::SEInfo(CUR_LOG_POSITION, TEXT("[SolarEngine] Module shutdown."));

}

IMPLEMENT_MODULE(FSEAnalyticsModule, SEAnalytics)

