// Copyright Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;
using System.IO;

public class SEAnalytics : ModuleRules
{
	public SEAnalytics(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;

		PublicIncludePaths.AddRange(new string[] {
			Path.Combine(ModuleDirectory, "Public")
		});

		PrivateIncludePaths.AddRange(new string[] {
			Path.Combine(ModuleDirectory, "Private")
		});

		PublicDependencyModuleNames.AddRange(new string[] {
            "Core",
                          // "SlateCore",
                          "CoreUObject",
                          "Engine",
                          "HTTP",
                          "Json",
                          "JsonUtilities",
                          "Sockets",
                          "EngineSettings"
		});
		
       // PublicDefinitions.Add("SEANALYTICS_API=");
       
                PrivateDependencyModuleNames.AddRange(
                new string[]
                {
                    // ... add private dependencies that you statically link with here ...
                    "Core",
                    // "SlateCore",
                    "Analytics",
                    "CoreUObject",
                    "Json",
                    "Engine",
                    "Projects",
                  
                    "Json",
                    "JsonUtilities",
           
                   
                    "EngineSettings"
                }
                );
	
		if (Target.Platform == UnrealTargetPlatform.IOS)
		{
			string FrameworkPath = Path.Combine(ModuleDirectory, "../ThirdParty/iOS/SolarEngineSDK.xcframework");
            
            string RcFrameworkPath = Path.Combine(ModuleDirectory, "../ThirdParty/iOS/SESDKRemoteConfig.xcframework");

			PublicAdditionalFrameworks.Add(
				new Framework("SolarEngineSDK", FrameworkPath)
			);
			PublicAdditionalFrameworks.Add(
				new Framework("SESDKRemoteConfig", RcFrameworkPath)
			);

			RuntimeDependencies.Add(
				Path.Combine(FrameworkPath, "ios-arm64/SolarEngineSDK.framework/SolarEngineSDK")
			);
            RuntimeDependencies.Add(
                Path.Combine(RcFrameworkPath, "ios-arm64/SESDKRemoteConfig.framework/SESDKRemoteConfig")
            );

			System.Console.WriteLine("[SolarEngine] ✅ iOS Framework added: " + FrameworkPath);
		}
        else if (Target.Platform == UnrealTargetPlatform.Android)
          {
              // Unreal Plugin Language
              string PluginPath = Utils.MakePathRelativeTo(ModuleDirectory, Target.RelativeEnginePath);
             AdditionalPropertiesForReceipt.Add("AndroidPlugin", System.IO.Path.Combine(PluginPath, "SEAnalytics_UPL.xml"));
              // JNI
              PublicIncludePathModuleNames.Add("Launch");
          }
	}
}
