//
//  SEAnalyticsJNI.h
//  unreal4sedemo (IOS)
//
//  Created by iMengqing on 2025/8/18.
//  Copyright © 2025 Epic Games, Inc. All rights reserved.
//
#pragma once

#include "CoreMinimal.h"              // 必须包含：FString, TArray, TSharedPtr, FJsonObject 等

#include <vector>
#include <string>
#include "SEAnalytics.h"

#include "../Common/SELog.h"
namespace solarengineanalytics {

extern "C"
{
 

// ========== 初始化相关 ==========
void jni_se_preInit(FString appkey);
void jni_se_init(FString appkey, FSEConfig config, FSECRemoteConfig remoteConfig);


// ========== 事件追踪 ==========
void jni_se_track(FString eventName, FString customAttributes, FString preAttributes);
void jni_se_trackIAPWithAttributes(FSEPurchaseEventAttributes attr);
void jni_se_trackAdImpressionWithAttributes(FImpressionAttributes att);
void jni_se_trackAdClickWithAttributes(FAdClickAttributes att);
void jni_se_trackAppAttrWithAttributes(FSEAttAttributes att);
void jni_se_trackRegisterWithAttributes(FRegisterEventAttributes att);
void jni_se_trackLoginWithAttributes(FLoginEventAttributes att);
void jni_se_trackOrderWithAttributes(FOrderEventAttributes att);
 void jni_se_trackAppReEngagement(FString properties);
void jni_se_trackFirst(FString  att);
void jni_se_eventStart(FString eventName);
void jni_se_eventFinish(FString eventName, FString propertiesJson);
void jni_se_reportEventImmediately();
 


// ========== 用户属性 ==========
void jni_se_userInit(FString properties);
void jni_se_userUpdate(FString properties);
void jni_se_userAdd(FString properties);
void jni_se_userUnset(FString Key);
void jni_se_userAppend(FString properties);
void jni_se_userDelete(int deleteType);

// ========== 全局属性 ==========
void jni_se_setSuperProperties(FString properties);
void jni_se_unsetSuperProperty(FString property);
void jni_se_setPresetEvent(ESEPresetEventType EventType, FString properties);

TSharedPtr<FJsonObject> jni_se_getPresetProperties();

// ========== 账号系统 ==========
void jni_se_loginWithAccountID(FString accountId);
void jni_se_logout();
void jni_se_setVisitorID(FString visitorId);
 void jni_se_setChannel(FString channel);
 void jni_se_setGaid(FString gaid);
 void jni_se_setOaid(FString oaid);
 void jni_se_setGDPRArea(bool isGDPRArea);
 FString jni_se_getDistinctId();
 FString jni_se_getVisitorID();
 FString jni_se_getAccountId();

 void jni_se_setDeferredDeeplinkCallback(FDeferredDeeplinkCallBack callback);
 void jni_se_setDeeplinkCallback(FDeeplinkCallBack callback);

 TSharedPtr<FJsonObject> jni_se_getAttributionData();

// ========== 在线参数 ==========
 void jni_se_setRemoteDefaultConfig(FString defaultConfig);
 void jni_se_setRemoteConfigEventProperties(FString properties);
 void jni_se_setRemoteConfigUserProperties(FString properties);
 FString jni_se_fastFetchRemoteConfig(FString key);
 TSharedPtr<FJsonObject> jni_se_fastAllFetchRemoteConfig();
 void jni_se_asyncFetchRemoteConfig(FString key, FonFetchRemoteConfigCallback callback);
 void jni_se_asyncAllFetchRemoteConfig(FonFetchAllRemoteConfigCallback callback);




} 

}
