#include "SEAnalytics.h"

#include "JsonObjectConverter.h"
#include "Dom/JsonObject.h"
#include "Serialization/JsonSerializer.h"
#include "Serialization/JsonWriter.h"
#include "./Common/SEUtil.h"
#include "Common/SELog.h"
#include "common/SEUtil.h"

#if PLATFORM_ANDROID
#include "./Android/SEAnalyticsJNI.h"
#elif PLATFORM_IOS
#include "./IOS/SEAnalyticsCpp.h"
#elif PLATFORM_WINDOWS
#elif PLATFORM_MAC
#endif


USEAnalytics::USEAnalytics(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer)
{
}



void USEAnalytics::preInit(const FString& appkey)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_preInit(appkey);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_preInit(appkey);
#endif
}


void USEAnalytics::init(
    const FString& appkey,
    const FSEConfig& config,
    const FSECRemoteConfig& remoteConfig){
    FSELog::SetEnableLog(config.logEnabled);
   
#if PLATFORM_IOS
    SEAnalyticsCpp::se_init(appkey, config,remoteConfig);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_init(appkey, config, remoteConfig);
#endif
}

FString USEAnalytics::getDistinctId()
{
#if PLATFORM_IOS
    return SEAnalyticsCpp::se_getDistinctId();
#elif PLATFORM_ANDROID
    return solarengineanalytics::jni_se_getDistinctId();
#else
    return FString("");
#endif
}

FString USEAnalytics::getAccountId()
{
#if PLATFORM_IOS
    return SEAnalyticsCpp::se_getAccountId();
#elif PLATFORM_ANDROID

    return solarengineanalytics::jni_se_getAccountId();
#else
    return FString("");
#endif   
    

}
FString USEAnalytics::getVisitorID()
{
#if PLATFORM_IOS
    return SEAnalyticsCpp::se_getVisitorID();
#elif PLATFORM_ANDROID
    return solarengineanalytics::jni_se_getVisitorID();
#else
    return FString("");
#endif
}

void USEAnalytics::login(const FString& accountId)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_loginWithAccountID(accountId);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_loginWithAccountID(accountId);
#endif
}

void USEAnalytics::logout()
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_logout();
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_logout();
#endif
}

void USEAnalytics::setVisitorID(const FString& VisitorID)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_setVisitorID(VisitorID);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_setVisitorID(VisitorID);
#endif
}

void USEAnalytics::setChannel(const FString& channel)
{

#if PLATFORM_IOS
    FSELog::Info("[SEAnalytics] setChannel: %s not support iOS", *channel);

#elif PLATFORM_ANDROID
    solarengineanalytics:: jni_se_setChannel(channel);
#endif
    
    
    
}
void USEAnalytics::setGaid(const FString& gaid)
{
    
#if PLATFORM_IOS
    FSELog::Info("[SEAnalytics] setGaid: %s not support iOS", *gaid);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_setGaid(gaid);
#endif
}
void USEAnalytics::setOaid(const FString& oaid)
{
    
#if PLATFORM_IOS
    FSELog::Info("[SEAnalytics] setOaid: %s not support iOS", *oaid);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_setOaid(oaid);
#endif
}


void USEAnalytics:: setGDPRArea(const bool& isGDPRArea)
{
    
#if PLATFORM_IOS
    SEAnalyticsCpp ::se_setGDPRArea(isGDPRArea);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_setGDPRArea(isGDPRArea);
#endif
}




void USEAnalytics::track(const FString& EventName, const  TSharedPtr<FJsonObject>& customAttributes,const  TSharedPtr<FJsonObject>& preAttributes)
{
    FString customAttributesJsonString=FSEUtil::ToJsonString(customAttributes);
   
    FString preAttributesJsonString=FSEUtil::ToJsonString(preAttributes);
 
#if PLATFORM_IOS
    SEAnalyticsCpp::se_track(EventName, customAttributesJsonString, preAttributesJsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_track(EventName, customAttributesJsonString, preAttributesJsonString);
#endif
}

void USEAnalytics::trackPurchase(const FSEPurchaseEventAttributes& att)
{

#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackIAPWithAttributes(att);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackIAPWithAttributes(att);
#endif
}

void USEAnalytics::trackAdImpression(const FImpressionAttributes& att)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackAdImpressionWithAttributes(att);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackAdImpressionWithAttributes(att);
#endif
}

void USEAnalytics::trackAdClick(const FAdClickAttributes& att)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackAdClickWithAttributes(att);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackAdClickWithAttributes(att);
#endif
}

void USEAnalytics::trackAttribution(const FSEAttAttributes& att)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackAppAttrWithAttributes(att);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackAppAttrWithAttributes(att);
#endif
}

void USEAnalytics::trackRegister(const FRegisterEventAttributes& att)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackRegisterWithAttributes(att);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackRegisterWithAttributes(att);
#endif
}

void USEAnalytics::trackLogin(const FLoginEventAttributes& att)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackLoginWithAttributes(att);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackLoginWithAttributes(att);
#endif
}

void USEAnalytics::trackOrder(const FOrderEventAttributes& att)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackOrderWithAttributes(att);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackOrderWithAttributes(att);
#endif
}

void USEAnalytics::trackFirstEvent(const FSEBaseAttributes& att)
{
    FString Json = FSEUtil::FirstEventToJsonString(att);
  
#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackFirst(Json);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackFirst(Json);

#endif
}

void USEAnalytics::trackAppReEngagement(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);


#if PLATFORM_IOS
    SEAnalyticsCpp::se_trackAppReEngagement(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_trackAppReEngagement(JsonString);
#endif
}


void USEAnalytics::eventStart(const FString& EventName)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_eventStart(EventName);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_eventStart(EventName);
#endif
}

void USEAnalytics::eventFinish(const FString& EventName,const TSharedPtr<FJsonObject>& Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);

#if PLATFORM_IOS
    SEAnalyticsCpp::se_eventFinish(EventName, JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_eventFinish(EventName, JsonString);
#endif
}

void USEAnalytics::reportEventImmediately()
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_reportEventImmediately();
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_reportEventImmediately();
#endif
}
// endregion

// region User Properties
void USEAnalytics::userInit(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);

#if PLATFORM_IOS
    SEAnalyticsCpp::se_userInit(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_userInit(JsonString);
#endif
}

void USEAnalytics::userUpdate(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);

#if PLATFORM_IOS
    SEAnalyticsCpp::se_userUpdate(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_userUpdate(JsonString);
#endif
}

void USEAnalytics::userAdd(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);

#if PLATFORM_IOS
    SEAnalyticsCpp::se_userAdd(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_userAdd(JsonString);
#endif
}

void USEAnalytics::userUnset(const TArray<FString>& keys)
{


#if PLATFORM_IOS
    SEAnalyticsCpp::se_userUnset(keys);
#elif PLATFORM_ANDROID
    FString JsonString;
    TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&JsonString);

    Writer->WriteArrayStart();
    for (const FString& Key : keys)
    {
        Writer->WriteValue(Key);
    }
    Writer->WriteArrayEnd();
    Writer->Close();
    solarengineanalytics::jni_se_userUnset(JsonString);
#endif
}

void USEAnalytics::userAppend(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);


#if PLATFORM_IOS
    SEAnalyticsCpp::se_userAppend(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_userAppend(JsonString);
#endif
}

void USEAnalytics::userDelete(int32 DeleteType)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_userDelete(DeleteType);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_userDelete(DeleteType);
#endif
}
// endregion

void USEAnalytics::setPresetEvent(ESEPresetEventType EventType, TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);

#if PLATFORM_IOS
    SEAnalyticsCpp::se_setPresetEvent(EventType, JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_setPresetEvent(EventType, JsonString);
#endif
}

// region Super Properties
void USEAnalytics::setSuperProperties(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);

#if PLATFORM_IOS
    SEAnalyticsCpp::se_setSuperProperties(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_setSuperProperties(JsonString);
#endif
}

void USEAnalytics::unsetSuperProperty(const FString& Property)
{
#if PLATFORM_IOS
    SEAnalyticsCpp::se_unsetSuperProperty(Property);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_unsetSuperProperty(Property);
#endif
}

void USEAnalytics::clearSuperProperties()
{
#if PLATFORM_IOS
    // SEAnalyticsCpp::se_clearSuperProperties();
#elif PLATFORM_ANDROID
  //  solarengineanalytics::jni_se_clearSuperProperties();
#endif
}

// region Preset Properties
TSharedPtr<FJsonObject> USEAnalytics::getPresetProperties()
{
#if PLATFORM_IOS
    return SEAnalyticsCpp::se_getPresetProperties();
 #elif PLATFORM_ANDROID
    return solarengineanalytics::jni_se_getPresetProperties();
#else
    return MakeShared<FJsonObject>();
#endif
}


TSharedPtr<FJsonObject> USEAnalytics::getAttributionData()
{
#if PLATFORM_IOS
    return SEAnalyticsCpp::se_getAttributionData();
 #elif PLATFORM_ANDROID
    return solarengineanalytics::jni_se_getAttributionData();
#else
    return MakeShared<FJsonObject>();
#endif
}

void USEAnalytics::setRemoteDefaultConfig(const std::vector<Item>& defaultConfig)
{
   FString JsonRoot= FSEUtil::getRemoteDefaultConfigJsonString(defaultConfig);
//    UE_LOG(LogTemp, Log, TEXT("setRemoteDefaultConfig: %s"), *JsonRoot)
#if PLATFORM_IOS
    SEAnalyticsCpp::se_setRemoteDefaultConfig(JsonRoot);
#elif PLATFORM_ANDROID
    solarengineanalytics::jni_se_setRemoteDefaultConfig(JsonRoot);
#endif
    
}
void USEAnalytics:: setRemoteConfigEventProperties(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);
  
#if PLATFORM_IOS
    SEAnalyticsCpp::se_setRemoteConfigEventProperties(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::
  jni_se_setRemoteConfigEventProperties(JsonString);
#endif
    
    
}
void USEAnalytics::setRemoteConfigUserProperties(TSharedPtr<FJsonObject> Properties)
{
    FString JsonString=FSEUtil::ToJsonString(Properties);
  
#if PLATFORM_IOS
    SEAnalyticsCpp::se_setRemoteConfigUserProperties(JsonString);
#elif PLATFORM_ANDROID
    solarengineanalytics::
  jni_se_setRemoteConfigUserProperties(JsonString);
#endif
    
    
}
FString USEAnalytics::fastFetchRemoteConfig(const FString& key)
{
#if PLATFORM_ANDROID
   return   solarengineanalytics:: jni_se_fastFetchRemoteConfig(key);
#elif PLATFORM_IOS
    return  SEAnalyticsCpp::se_fastFetchRemoteConfig(key);
   
#else
    return  FString("");
   
#endif
}

 TSharedPtr<FJsonObject> USEAnalytics::fastAllFetchRemoteConfig()
{
#if PLATFORM_ANDROID
     return solarengineanalytics::jni_se_fastAllFetchRemoteConfig();
#elif PLATFORM_IOS
    return SEAnalyticsCpp::se_fastAllFetchRemoteConfig();
  
#else
    return MakeShared<FJsonObject>();
   
#endif
}
void USEAnalytics::asyncFetchRemoteConfig(const FString& key,const  FonFetchRemoteConfigCallback&  callback)
{
#if PLATFORM_ANDROID
    solarengineanalytics::jni_se_asyncFetchRemoteConfig(key, callback);
#elif PLATFORM_IOS
    SEAnalyticsCpp::se_asyncFetchRemoteConfig(key, callback);
  
#else
   
#endif
   
}
void USEAnalytics::asyncAllFetchRemoteConfig(const FonFetchAllRemoteConfigCallback&  callback)
{
#if PLATFORM_ANDROID
    solarengineanalytics::jni_se_asyncAllFetchRemoteConfig(callback);
#elif PLATFORM_IOS
    SEAnalyticsCpp::se_asyncAllFetchRemoteConfig(callback);
    
  
#else
   
#endif
   
}
void USEAnalytics::setDeferredDeeplinkCallback(const FDeferredDeeplinkCallBack&  callback)
{
#if PLATFORM_ANDROID

    solarengineanalytics::jni_se_setDeferredDeeplinkCallback(callback);
#elif PLATFORM_IOS

    SEAnalyticsCpp::se_setDeferredDeeplinkCallback(callback);
    
#else
   
#endif
}
void USEAnalytics::setDeepLinkCallback( const FDeeplinkCallBack&  callback)
{
#if PLATFORM_ANDROID

    solarengineanalytics::jni_se_setDeeplinkCallback(callback);
#elif PLATFORM_IOS

    SEAnalyticsCpp::se_setDeepLinkCallBack(callback);
    
#else
   
#endif
}

void USEAnalytics::requestTrackingAuthorization( const FonRequestTrackingAuthorizationCallback&  callback)
{
#if PLATFORM_ANDROID

#elif PLATFORM_IOS

    SEAnalyticsCpp::se_requestTrackingAuthorization(callback);
    
#else
   
#endif
}


void USEAnalytics::appDeeplinkOpenURL(const FString& url)
{
#if PLATFORM_ANDROID

#elif PLATFORM_IOS

    SEAnalyticsCpp::se_appDeeplinkOpenURL(url);
    
#else
#endif
}

